% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_draw}
\alias{cpp_draw}
\title{Draw Shape to Image}
\arguments{
\item{img}{an IntegerVector. A non null array of dimensions [nrow, ncol, 4].}

\item{coords}{an IntegerMatrix whose rows are points to draw and with:\cr
- 1st column being img col coordinate in px,\cr
- 2nd column being img row coordinate in px.}

\item{mask}{a LogicalMatrix where every true value will be added to the image.}

\item{color, }{a 4 rows IntegerMatrix specifying rgba, from 0 to 255.}

\item{blur_size, }{a R_len_t the size of the gaussian blurring kernel. Default is 9.}

\item{blur_sd, }{a double the sd of the gaussian blurring kernel. Default is 3.0.}
}
\value{
/!\ nothing is returned but img is modified in-place
}
\description{
low-level function to add shape on image
}
\details{
shape according to 'mask' will be drawn on 'img' centered at coordinates coords[, 1], coords[, 0]
and every pixels being part of the shape will be filled with 'color'.
If only one 'color' is provided, this 'color' will be used for each points.
If more than one 'color' is provided, then if number of colors (ncol) equals the number of points 'color' will be used as is for each single point.
Otherwise, 'color' will be considered as a color-gradient and density will be computed.
/!\ please note that IFC:::densCols() is faster to compute color based on density for n < 20000 points, so it's worth using it when number of points are lower.
}
\keyword{internal}
