% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mint.R
\name{h.fn}
\alias{h.fn}
\title{Mean Intensity Function of the Self-Exciting Point Process
\code{h.fn} calculate the values of the mean intensity function of the self-exciting process with given baseline event rate and excitation function at a (fairly large) number of points. Values of the function at other points can be obtained by interpolation (e.g. spline interpolation).}
\usage{
h.fn(nu, g, N = 2^12, to = 1, abs.tol = 1e-10, maxit = 100)
}
\arguments{
\item{nu}{a (vectorized) function specifying the baseline invent rate of the SEPP}

\item{g}{a (vectorized) function specifying the excitation function of the SEPP}

\item{N}{an integer giving the number of equal sized intervals to partition the domain into during the calculation The larger this value is, the more accurately the solution approxmates the truth, and the more time requred to evaluate.}

\item{to}{a numeric scalar, the end point of the estimation domain}

\item{abs.tol}{a numeric scalar specifying the absolute tolerance of error}

\item{maxit}{an integer specifying the maximal number of iterations allowed}
}
\value{
a list with elelents, \code{x}: the vector of the points where \eqn{h} is evaluated; \code{y}: the vector of the corresponding \eqn{h} values; \code{nit}: the number of iterations used; \code{G.err}: the approximation error in \eqn{G}.
}
\description{
Mean Intensity Function of the Self-Exciting Point Process
\code{h.fn} calculate the values of the mean intensity function of the self-exciting process with given baseline event rate and excitation function at a (fairly large) number of points. Values of the function at other points can be obtained by interpolation (e.g. spline interpolation).
}
\examples{
\dontrun{
nu <- function(x)(200+100*cos(pi*x))*(x>=0);
g <- function(x) 2*exp(-x)
h.l <- h.fn(nu=nu,g=g,to=5);
h <- splinefun(h.l$x,h.l$y);
x <- 1:500/100;
max(nu(x)+sapply(x,function(x)integrate(function(u)g(x-u)*h(u),0,x)$value) - h(x))
}
}
\seealso{
\code{\link{h.fn.exp}}
}

