% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILS.R
\docType{data}
\name{Glucose}
\alias{Glucose}
\title{Glucose in Serum}
\format{A data frame with 120 observations composed of the following 4 variables:
\describe{
  \item{Glucose}{Glucose content in Serum}
  \item{Replicate}{Number of glucose measurement corresponding to each material}
  \item{Material}{Level of glucose, ranging from low content of sugar to very high level of glucose in blood.}
  \item{Laboratory}{Laboratories conducted tests}
}}
\description{
Dataset corresponding to serum glucose (measurements of glucose concentration in blood used to control diabetes) testing.
Eight laboratories conducted tests to five different blood samples tagged with different references, ranging them from low  sugar content to very high.
Three replicates were obtained for each sample. It is retrieved from ASTM E 691 standard.
}
\examples{
library(ILS)
data(Glucose)
summary(Glucose)
attach(Glucose)
str(Glucose)
table(Replicate,Material,Laboratory)
table(Laboratory,Material)
st <- with(Glucose, tapply(Glucose, list(Material,Laboratory), mean))
st

}
\references{
\describe{
  \item{}{ASTM E 691 (1999). Standard  practice  for  conducting  an  interlaboratory  study  to  determine
the precision of a test method. American Society for Testing and Materials. West Conshohocken, PA, USA. }
}
}
\keyword{datasets}
