% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center.R
\name{center}
\alias{center}
\alias{grand.mean}
\alias{group.mean}
\alias{getgroup.mean}
\title{Centering}
\usage{
center(X, group = NULL, grandmean = NULL, groupmean = NULL, wt = NULL)

grand.mean(x, wt = NULL)

group.mean(x, group, wt = NULL)

getgroup.mean(x, group, wt = NULL)
}
\arguments{
\item{X}{a matrix or a data frame.}

\item{group}{a vector indicating the group for centering.}

\item{grandmean}{a numeric or character vector indicating the number or the
the names of columns of \code{X} to which grand-mean should be applied.}

\item{groupmean}{a numeric or character vector indicating the number or the
the names of columns of \code{X} to which group-mean should be applied.}

\item{wt}{a numeric vector of weights.}

\item{x}{a vector, a matrix or a data frame.}
}
\value{
a data frame, or a vector.
}
\description{
Centers a vector, a matrix or a data frame to the grand mean or the group mean.
}
\examples{
# Less data for shorter example
repdata2 <- repdata[1:10,c(1:3,6:10,51)]

### One variable ----

# grand-mean
grand.mean(repdata2$item01)
grand.mean(repdata2$item01,wt = repdata2$wt)

# group-mean
group.mean(repdata2$item01,group = repdata2$GROUP)
group.mean(repdata2$item01,group = repdata2$GROUP,wt = repdata2$wt)

### More than one variable with the same rule ----

# grand-mean
grand.mean(repdata2[,4:8])
grand.mean(repdata2[,4:8],wt = repdata2$wt)

# group-mean
group.mean(repdata2[,4:8],group = repdata2$GROUP)
group.mean(repdata2[,4:8],group = repdata2$GROUP,wt = repdata2$wt)

### More than one variable with different rules ----
center(repdata2, group = repdata2$GROUP, grandmean = 4:5, groupmean = 6:8, wt = repdata2$wt)
center(repdata2, group = repdata2$GROUP, grandmean = 6:8, groupmean = 4:5, wt = repdata2$wt)

center(repdata2, group = repdata2$GROUP, wt = repdata2$wt,
       grandmean = paste0("item0",1:3), groupmean = paste0("item0",4:5))
center(repdata2, group = repdata2$GROUP, wt = repdata2$wt,
       grandmean = paste0("item0",4:5), groupmean = paste0("item0",1:3))
}
