% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullConditionals.R
\name{is.posi_def}
\alias{is.posi_def}
\title{Check Postive-(Semi)definiteness of a matrix}
\usage{
is.posi_def(x, tol = NULL, semi = FALSE)
}
\arguments{
\item{x}{A matrix, assumed to be real and symmetric.}

\item{tol}{Tolerance for singular values and for absolute eigenvalues - only those with values larger than tol are considered non-zero (default: tol = \code{max(dim(x))*max(E)*.Machine$double.eps}, where \code{E} is the vector of absolute eigenvalues).}

\item{semi}{Logical switch to test for positive-semidefiniteness when \code{TRUE} or positive-definiteness when \code{FALSE} (the default).}
}
\value{
A logical value (\code{TRUE} or \code{FALSE})
}
\description{
Tests whether all eigenvalues of a symmetric matrix are positive (or strictly non-negative).
}
\examples{
x <- cov(matrix(rnorm(100), nrow=10, ncol=10))
is.posi_def(x)
is.posi_def(x, semi=TRUE)
}
