% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INCA.DEG.R
\name{INCA.DEG}
\alias{INCA.DEG}
\title{INCATome Deregulated Genes Identification}
\usage{
INCA.DEG(x, cl, wcol, filt = TRUE, selneg, base = 2, highlight = NULL)
}
\arguments{
\item{x}{an RGList object}

\item{cl}{a vector specifying type of samples, 0 being control and 1 being condition.}

\item{wcol}{an integer specifying the number of the column where Gene Names can be found in the gene annotation table.}

\item{filt}{logical, TRUE if a set of negative control probes are to be used for filtering. Filtering is performed by removing any probes for which the average intensities are lower than the "negative" mean +/- 1.5 "negative" deviation.}

\item{selneg}{a character or vector containing the negative control probe names for filtering.}

\item{base}{an integer specifying the log base. Default is 2.}

\item{highlight}{a character vector specifying a set of genes of interest. These will be highlighted in the graphical representations.}
}
\value{
A List object containing the INCA DEG output for significant DEGs with INCA DEG Score >= 2, as well as all individual outputs from the different tests. Additionally, volcanoplots for each test will be generated.
}
\description{
Performs the INCATome DEG identification for microarray data, consisting of an overlap of at least two out of four DEG tests (TTest, Limma, RankProd and SAM).
}
\examples{
#Load the INCATome Dataset
data(INCATomeData)
attach(INCATomeData)
out=INCA.DEG(RGdataDS,c(0,0,0,1,1,1),8,filt=TRUE,
 selneg="NegativeControl", highlight=c("ACTB","PABPC1"))
}
