% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_trend.R
\name{model_trend}
\alias{model_trend}
\title{Modeling of indicator trends}
\usage{
model_trend(ind_tbl, time, train = 1, random = FALSE, k = 4,
  family = stats::gaussian())
}
\arguments{
\item{ind_tbl}{A data frame, matrix or tibble containing only the (numeric) IND
variables. Single indicators should be coerced into a data frame to keep the
indicator name. If kept as vector, default name will be `ind`.}

\item{time}{A vector containing the actual time steps (e.g. years; should be the same
for the IND data).}

\item{train}{The proportion of observations that should go into the training data
on which the GAMs are fitted. Has to be a numeric value between 0 and 1; the default
is 1 (i.e. the full time series is fitted).}

\item{random}{logical; should the observations for the training data be randomly
chosen? Default is FALSE.}

\item{k}{Choice of knots (for the smoothing function \code{\link{s}}); the
default is 4.}

\item{family}{A description of the error distribution and link to be used in the GAM.
This needs to be defined as a family function (see also \code{\link{family}}). All
standard family functions can be used as well some of the distribution families in
the mgcv package (see \code{\link[mgcv]{family.mgcv}}; e.g.\code{\link[mgcv]{negbin}}
or \code{\link[mgcv]{nb}}).}
}
\value{
The function returns a \code{\link[tibble]{tibble}}, which is a trimmed down version of
the data.frame(), including the following elements:
\describe{
  \item{\code{ind_id}}{Indicator IDs.}
  \item{\code{ind}}{Indicator names.}
  \item{\code{p_val}}{The p values for the smoothing term (here time).}
  \item{\code{model}}{A list-column of indicator-specific gam objects.}
  \item{\code{ind_train}}{A list-column with indicator values of the training data.}
  \item{\code{time_train}}{A list-column with the time values (e.g. years) of the
             training data.}
  \item{\code{pred}}{A list-column with indicator values predicted from the GAM
             for the training period.}
  \item{\code{ci_up}}{A list-column with the upper 95\% confidence interval of
             predicted indicator values.}
  \item{\code{ci_low}}{A list-column with the lower 95\% confidence interval of
             predicted indicator values.}
}
}
\description{
The function models the long-term trend of each indicator (IND) based on
Generalized Additive Models (GAM) and returns a tibble with
IND-specific GAM outputs.
}
\details{
To test for linear or non-linear long-term changes, each indicator (IND)
in the ind_tbl is modeled as a smoothing function of the time vector
(usually years) using the \code{\link[mgcv]{gam}} function. The trend can
be tested for the full time series (i.e. all observations are used as
training data) or for a random or selected subset.

The GAMs are build using the default settings in the \code{gam} function and
the smooth term function \code{\link[mgcv]{s}}).  However, the user can adjust
the distribution and link by modifying the family argument as well as the
maximum level of non-linearity by setting the number of knots:

\code{gam(ind ~ s(time, k = k), family = family, data = training_data)}
}
\examples{
# Using the Baltic Sea demo data in this package
ind_tbl <- ind_ex[ ,-1] # excluding the year
time <- ind_ex$Year
# Using the default settings
trend_tbl <- model_trend(ind_tbl, time)
# Change the training and test data assignment
model_trend(ind_tbl, time, train = .5, random = TRUE)
# To keep the name when testing only one indicator, coerce vector to data frame
model_trend(data.frame(MS = ind_tbl$MS), time, train = .5, random = TRUE)
}
\seealso{
\code{\link{plot_diagnostics}} for assessing model diagnostics,
 \code{\link{plot_trend}} for trend visualization,
 \code{\link[tibble]{tibble}} and the \code{vignette("tibble")} for more
 information on tibbles,
 \code{\link[mgcv]{gam}} for more information on GAMs
}
