% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_resp.R
\name{expect_resp}
\alias{expect_resp}
\title{Score adjustments for sub-criterion 10.1}
\usage{
expect_resp(mod_tbl, scores_tbl, crit_scores = INDperform::crit_scores_tmpl)
}
\arguments{
\item{mod_tbl}{Output tibble from the IND~pressure modeling functions.}

\item{scores_tbl}{The output tibble from the \code{\link{scoring}} function.}

\item{crit_scores}{The(un)modified criterion-scoring template \code{crit_scores_tmpl};
has to be the same than used in \code{scoring}. Default is the unmodified
template \code{crit_scores_tmpl}.}
}
\value{
The function returns the input scoring tibble, but with modified scores
in the variable \code{C10_1}, once the "Press Me!" button is activated.
}
\description{
\code{expect_resp} runs a shiny app in which the expectation of the IND response to
a pressure (sub-criterion 10.1) can be manually changed to `yes` or `no` based on
visual inspection of the IND response curve.
}
\details{
The sub-criterion 10.1 (i.e. the IND response to a pressure, which has been found significant,
is in line with expectations based on ecological knowledge) has been set
to a default score of 1 (no expectation / unclear as response is highly non-linear)
in the \code{\link{scoring}} function. Determining whether the IND response modeled in
the GAM/GAMM meets specific expectations can only be done
based on visual model inspections. \code{expect_resp} provides only a very simple
graphical representation of this smoothing function.

For a more comprehensive figure use the \code{\link{plot_model}}
function and then go back to this function for modifications
of the expectation scores.
}
\examples{
\dontrun{
 # Using the Baltic Sea demo data:
 # Apply first the scoring on the model outputs
 scores_tbl <- scoring(trend_tbl = model_trend_ex, mod_tbl = all_results_ex,
   press_type = press_type_ex)
 # Then run the expect_resp() shiny function to correct one criterion
 scores_tbl <- expect_resp(all_results_ex, scores_tbl)
 # Check if it worked:
 expect_resp(all_results_ex, scores_tbl)
}
}
\seealso{
\code{\link{plot_model}} for visualization of the IND responses to pressures

Other score-based IND performance functions: 
\code{\link{clust_sc}()},
\code{\link{dist_sc_group}()},
\code{\link{dist_sc}()},
\code{\link{plot_clust_sc}()},
\code{\link{plot_spiechart}()},
\code{\link{scoring}()},
\code{\link{summary_sc}()}
}
\concept{score-based IND performance functions}
