% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_inla.R
\name{plot_random_effects}
\alias{plot_random_effects}
\alias{plot_fixed_marginals}
\alias{plot_hyper_marginals}
\alias{plot_marginals_fitted}
\title{Individual plot functions for INLA objects}
\usage{
plot_random_effects(x, type = "line")

plot_fixed_marginals(x, priors = FALSE, CI = FALSE)

plot_hyper_marginals(x, CI = FALSE)

plot_marginals_fitted(x)
}
\arguments{
\item{x}{An inla object}

\item{type}{Which type of plot? 'boxplot' or 'line'}

\item{priors}{Logical, plot priors as well.}

\item{CI}{Plot credible intervals. TRUE for 95\% CI or a numeric in [0, 1]}
}
\description{
Replicate the individual plots produced by \code{\link{plot}} using ggplot.
}
\examples{
\dontrun{
 library(INLA)
 data(Epil)
 ##Define the model
 formula = y ~ Trt + Age + V4 +
          f(Ind, model="iid") + f(rand,model="iid")
 result = inla(formula, family="poisson", data = Epil, control.predictor = list(compute = TRUE))

 plot_random_effects(result)
 plot_random_effects(result, type = 'boxplot')
 plot_fixed_marginals(result)
 plot_hyper_marginals(result)
}
}
