% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSetList.R
\name{generate_data.EAF_diff_Approximate}
\alias{generate_data.EAF_diff_Approximate}
\title{Generate EAF-differences between each function and the remaining portfolio}
\usage{
generate_data.EAF_diff_Approximate(
  dsList,
  xmin,
  xmax,
  ymin,
  ymax,
  x.log = T,
  y.log = T
)
}
\arguments{
\item{dsList}{The DataSetList object, containing at least 2 IDs}

\item{xmin}{Minimum runtime to consider}

\item{xmax}{Maximum runtime to consider}

\item{ymin}{Minimum f(x) to consider}

\item{ymax}{Maximum f(x) to consider}

\item{x.log}{Whether to scale the y-space logarithmically}

\item{y.log}{Whether to scale the y-space logarithmically}
}
\description{
This is an approximation of ``, since the number of required polygons
can quickly become problematic for plotly. This function uses discretized
contour matrices instead, which trades off accuracy for scalability.
}
\examples{
generate_data.EAF_diff_Approximate(subset(dsl, funcId == 1), 1, 16, 1, 16)
}
