% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.gain.R
\name{output.gain}
\alias{output.gain}
\title{Summary For Genetic Gain}
\usage{
output.gain(result)
}
\arguments{
\item{result}{list. The data list of the output from simu.GEBVO, simu.GDO,
or simu.GEBVGD.}
}
\value{
The output contains the table of the GEBV average of parental lines, the GEBV
average of the last generation in simulation process, and the genetic gain
average over repetitions for each target trait.
}
\description{
Output the GEBV average of parental lines, the GEBV average of the last
generation in simulation process, and the genetic gain average over repetitions
for each target trait.
}
\examples{
# generate simulated data
set.seed(2000)
t1 <- rnorm(10,30,10)
t2 <- rnorm(10,10,5)
t3 <- NULL
t4 <- NULL
t5 <- NULL
geno.test <- matrix(sample(c(1, -1), 200, replace = TRUE), 10, 20)
marker.test <- cbind(rep(1:2, each=10), rep(seq(0, 90, 10), 2))
fit <- GBLUP.fit(t1, t2, t3, t4, t5, geno = geno.test)

geno.candidate <- matrix(sample(c(1,-1), 300, replace = TRUE), 15, 20)

# run
result <- simu.GEBVO(fit, geno.test, marker.test, geno.candidate,
nprog = 5, nsele = 10, ngen = 5, nrep = 5)

# summary for genetic gain
output <- output.gain(result)
output
}
\references{
Chung PY, Liao CT. 2020. Identification of superior parental lines for
biparental crossing via genomic prediction. PLoS ONE 15(12):e0243159.
}
\seealso{
\code{\link[IPLGP]{simu.GEBVO}}
\code{\link[IPLGP]{simu.GDO}}
\code{\link[IPLGP]{simu.GEBVGD}}
}
