% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITNblock_plot_function.R
\name{ITNblock_plot}
\alias{ITNblock_plot}
\title{ITN Blockmodel Plot}
\usage{
ITNblock_plot(gs, LABEL)
}
\arguments{
\item{gs}{International Trade Network - igraph object}

\item{LABEL}{Should labels be present - TRUE/FALSE}
}
\value{
Network Plot - nodes coloured based on block membership
}
\description{
This function calculates block membership for the ITN and then plots the network, with node colour according to block membership.
}
\examples{
require(igraph)
require(sna)
require(intergraph)

##Create random International Trade Network (igraph object)
ITN<-erdos.renyi.game(75,0.05,directed = TRUE)

##Add edge weights
E(ITN)$weight<-runif(ecount(ITN), 0, 1)

##Blockmodel plot
block_plot<-ITNblock_plot(ITN,FALSE)

}
