% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITNcentrality_binary_function.R
\name{ITNcentrality_binary}
\alias{ITNcentrality_binary}
\title{ITN Centrality for binary networks}
\usage{
ITNcentrality_binary(gs)
}
\arguments{
\item{gs}{International Trade Network - binary igraph object}
}
\value{
Table of centrality results (dataframe)
}
\description{
This function calculates a number of centrality metrics for the binary International Trade Network (ITN)
}
\examples{
require(igraph)
##Create random International Trade Network (igraph object)
ITN<-erdos.renyi.game(75,0.05,directed = TRUE)


##Add vertex names
V(ITN)$name<-1:vcount(ITN)

##Calculate the centrality measures
ITNCENT<-ITNcentrality_binary(ITN)

}
