% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_region}
\alias{get_region}
\title{Get polygons corresponding to regions}
\usage{
get_region(dat, dat_type, level = NULL, my_land_mat = land_mat,
  my_all_regions = all_regions, use_all = FALSE, land_ind = FALSE,
  xmn = -3850, xmx = 3750, ymn = -5350, ymx = 5850)
}
\arguments{
\item{dat}{matrix of one of the allowed data types ("gfdl", "bootstrap", or
"simple)  (see details)}

\item{dat_type}{string indicating the format of the data: either "gfdl",
"bootstrap", or "simple" (see details)}

\item{level}{concentration level of interest}

\item{my_land_mat}{binary matrix specifying land locations}

\item{my_all_regions}{\code{SpatialPolygons} object specifying region that will
be considered}

\item{use_all}{boolean, if true indicates to use the full area (overrides
\code{land_mat})}

\item{land_ind}{boolean, if true indicates that the region of interest is the
land}

\item{xmn}{min x dimension (defaults to value for polar stereographic grid: -3850)}

\item{xmx}{max x dimension (defaults to value for polar stereographic grid: 3750)}

\item{ymn}{min y dimension (defaults to value for polar stereographic grid: -5350)}

\item{ymx}{max y dimension (defaults to value for polar stereographic grix: 5850)}
}
\value{
region of interest as a \code{SpatialPolygons} object
}
\description{
Takes in a matrix and returns a \code{SpatialPolygon} object
representing regions fitting some criteria. Typically these regions are
either where the sea ice concentration is above a certain level or
where there is land.
}
\details{
For \code{datType = "simple"}  the values in the \code{dat} matrix
         are indicators of whether the grid box contains ice (1: ice-covered,
         0: no ice, NA: land). If \code{datType = "gfdl"} or
         \code{datType  = "bootstrap"}, the values in the matrix correspond
         to the raw ice concentrations values observed or predicted
         (including indicators for missing data, land etc.). If
         \code{datType = "gfdl"}, the predictions are formatted as in the
         CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model produced
         by the National Oceanic and Atmospheric Administration’s Geophysical
         Fluid Dynamics Laboratory converted to a Polar Stereographic grid
         (Vecchi et al. 2014; Msadek et al. 2014). If
           \code{datType = "bootstrap"} the array values are formatted the same
         as the ice concentration values obtained from the  National
         Aeronautics and Space Administration (NASA) satellites Nimbus-7
         SMMR and DMSP SSM/I-SSMIS and processed by the bootstrap algorithm.
}
\examples{
\dontrun{
obs_example <-  get_region(dat = obsFeb2012, dat_type = "bootstrap", level = 15)
plot(land, col = 'grey', border = FALSE)
plot(obs_example, col = "lightblue", add = TRUE)
}
}
\references{
Bootstrap sea ice concentration:
            Comiso, J., 2017: Bootstrap sea ice concentrations
            from Nimbus-7 SMMR and DMSP SSM/I-SSMIS. version 3.
            {Boulder, Colorado USA: NASA National Snow and Ice Data Center
            Distributed Active Archive Center}

           CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model:Vecchi,
           Gabriel A., et al.
           \href{http://journals.ametsoc.org/doi/abs/10.1175/JCLI-D-14-00158.1}{"On the seasonal forecasting of regional tropical cyclone activity."}
           Journal of Climate 27.21 (2014): 7994-8016.

           Msadek, R., et al.
           \href{http://onlinelibrary.wiley.com/doi/10.1002/2014GL060799/full}{"Importance of initial conditions in seasonal predictions of Arctic sea ice extent."}
           Geophysical Research Letters
           41.14 (2014): 5208-5215.
}
