/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;

public class WrapperObjectMatrix1D
extends ObjectMatrix1D {
    private static final long serialVersionUID = 1L;
    protected ObjectMatrix1D content;

    public WrapperObjectMatrix1D(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D != null) {
            this.setUp((int)objectMatrix1D.size());
        }
        this.content = objectMatrix1D;
    }

    protected ObjectMatrix1D getContent() {
        return this.content;
    }

    public synchronized Object getQuick(int n) {
        return this.content.getQuick(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    public ObjectMatrix1D like(int n) {
        return this.content.like(n);
    }

    public ObjectMatrix2D like2D(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public ObjectMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public ObjectMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public synchronized void setQuick(int n, Object object) {
        this.content.setQuick(n, object);
    }

    public ObjectMatrix1D viewFlip() {
        WrapperObjectMatrix1D wrapperObjectMatrix1D = new WrapperObjectMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n) {
                return this.content.getQuick(this.size - 1 - n);
            }

            public synchronized void setQuick(int n, Object object) {
                this.content.setQuick(this.size - 1 - n, object);
            }

            public synchronized Object get(int n) {
                return this.content.get(this.size - 1 - n);
            }

            public synchronized void set(int n, Object object) {
                this.content.set(this.size - 1 - n, object);
            }
        };
        return wrapperObjectMatrix1D;
    }

    public ObjectMatrix1D viewPart(final int n, int n2) {
        this.checkRange(n, n2);
        WrapperObjectMatrix1D wrapperObjectMatrix1D = new WrapperObjectMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n2) {
                return this.content.getQuick(n + n2);
            }

            public synchronized void setQuick(int n2, Object object) {
                this.content.setQuick(n + n2, object);
            }

            public synchronized Object get(int n2) {
                return this.content.get(n + n2);
            }

            public synchronized void set(int n2, Object object) {
                this.content.set(n + n2, object);
            }
        };
        wrapperObjectMatrix1D.setSize(n2);
        return wrapperObjectMatrix1D;
    }

    public ObjectMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        final int[] nArray2 = nArray;
        WrapperObjectMatrix1D wrapperObjectMatrix1D = new WrapperObjectMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n) {
                return this.content.getQuick(nArray2[n]);
            }

            public synchronized void setQuick(int n, Object object) {
                this.content.setQuick(nArray2[n], object);
            }

            public synchronized Object get(int n) {
                return this.content.get(nArray2[n]);
            }

            public synchronized void set(int n, Object object) {
                this.content.set(nArray2[n], object);
            }
        };
        wrapperObjectMatrix1D.setSize(nArray.length);
        return wrapperObjectMatrix1D;
    }

    protected ObjectMatrix1D viewSelectionLike(int[] nArray) {
        throw new InternalError();
    }

    public ObjectMatrix1D viewStrides(final int n) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperObjectMatrix1D wrapperObjectMatrix1D = new WrapperObjectMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int n2) {
                return this.content.getQuick(n2 * n);
            }

            public synchronized void setQuick(int n2, Object object) {
                this.content.setQuick(n2 * n, object);
            }

            public synchronized Object get(int n2) {
                return this.content.get(n2 * n);
            }

            public synchronized void set(int n2, Object object) {
                this.content.set(n2 * n, object);
            }
        };
        wrapperObjectMatrix1D.setSize(this.size);
        if (this.size != 0) {
            wrapperObjectMatrix1D.setSize((this.size - 1) / n + 1);
        }
        return wrapperObjectMatrix1D;
    }
}

