/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.tdouble.DoubleIHistogram1D;
import hep.aida.tdouble.DoubleIHistogram2D;
import hep.aida.tdouble.DoubleIHistogram3D;
import hep.aida.tdouble.ref.DoubleConverter;
import hep.aida.tdouble.ref.DoubleHistogram1D;
import hep.aida.tdouble.ref.DoubleHistogram2D;
import hep.aida.tdouble.ref.DoubleHistogram3D;
import hep.aida.tdouble.ref.DoubleVariableAxis;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;

public class Test2 {
    public static void main2(String[] stringArray) {
        Random random = new Random();
        DoubleHistogram1D doubleHistogram1D = new DoubleHistogram1D("AIDA 1D Histogram", 40, -3.0, 3.0);
        for (int i = 0; i < 10000; ++i) {
            doubleHistogram1D.fill(random.nextGaussian());
        }
        DoubleHistogram2D doubleHistogram2D = new DoubleHistogram2D("AIDA 2D Histogram", 40, -3.0, 3.0, 40, -3.0, 3.0);
        for (int i = 0; i < 10000; ++i) {
            doubleHistogram2D.fill(random.nextGaussian(), random.nextGaussian());
        }
        Test2.writeAsXML(doubleHistogram1D, "aida1.xml");
        Test2.writeAsXML(doubleHistogram2D, "aida2.xml");
        Test2.writeAsXML(doubleHistogram2D.projectionX(), "projectionX.xml");
        Test2.writeAsXML(doubleHistogram2D.projectionY(), "projectionY.xml");
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{-30.0, 0.0, 30.0, 1000.0};
        Random random = new Random();
        DoubleHistogram1D doubleHistogram1D = new DoubleHistogram1D("AIDA 1D Histogram", new DoubleVariableAxis(dArray));
        for (int i = 0; i < 10000; ++i) {
            doubleHistogram1D.fill(random.nextGaussian());
        }
        DoubleHistogram2D doubleHistogram2D = new DoubleHistogram2D("AIDA 2D Histogram", new DoubleVariableAxis(dArray), new DoubleVariableAxis(dArray));
        for (int i = 0; i < 10000; ++i) {
            doubleHistogram2D.fill(random.nextGaussian(), random.nextGaussian());
        }
        DoubleHistogram3D doubleHistogram3D = new DoubleHistogram3D("AIDA 3D Histogram", 10, -2.0, 2.0, 5, -2.0, 2.0, 3, -2.0, 2.0);
        for (int i = 0; i < 10000; ++i) {
            doubleHistogram3D.fill(random.nextGaussian(), random.nextGaussian(), random.nextGaussian());
        }
        Test2.writeAsXML(doubleHistogram1D, "aida1.xml");
        Test2.writeAsXML(doubleHistogram2D, "aida2.xml");
        Test2.writeAsXML(doubleHistogram3D, "aida2.xml");
        Test2.writeAsXML(doubleHistogram2D.projectionX(), "projectionX.xml");
        Test2.writeAsXML(doubleHistogram2D.projectionY(), "projectionY.xml");
    }

    private static void writeAsXML(DoubleIHistogram1D doubleIHistogram1D, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println(new DoubleConverter().toXML(doubleIHistogram1D));
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeAsXML(DoubleIHistogram2D doubleIHistogram2D, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println(new DoubleConverter().toXML(doubleIHistogram2D));
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeAsXML(DoubleIHistogram3D doubleIHistogram3D, String string) {
        System.out.println(new DoubleConverter().toString(doubleIHistogram3D));
    }
}

