/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2DTest;
import cern.colt.matrix.tdcomplex.impl.DenseColumnDComplexMatrix2D;

public class DenseColumnDComplexMatrix2DTest
extends DComplexMatrix2DTest {
    public DenseColumnDComplexMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseColumnDComplexMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new DenseColumnDComplexMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new DenseColumnDComplexMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testAssignDoubleArray() {
        double[] dArray = new double[2 * (int)this.A.size()];
        int n = 0;
        while ((long)n < 2L * this.A.size()) {
            dArray[n] = Math.random();
            ++n;
        }
        this.A.assign(dArray);
        n = 0;
        for (int i = 0; i < this.A.columns(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                double[] dArray2 = this.A.getQuick(j, i);
                DenseColumnDComplexMatrix2DTest.assertEquals((double)dArray[n], (double)dArray2[0], (double)this.TOL);
                DenseColumnDComplexMatrix2DTest.assertEquals((double)dArray[n + 1], (double)dArray2[1], (double)this.TOL);
                n += 2;
            }
        }
    }

    public void testAssignFloatArray() {
        float[] fArray = new float[this.NROWS * 2 * this.NCOLUMNS];
        int n = 0;
        while ((long)n < 2L * this.A.size()) {
            fArray[n] = (float)Math.random();
            ++n;
        }
        this.A.assign(fArray);
        n = 0;
        for (int i = 0; i < this.A.columns(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                double[] dArray = this.A.getQuick(j, i);
                DenseColumnDComplexMatrix2DTest.assertEquals((double)fArray[n], (double)dArray[0], (double)this.TOL);
                DenseColumnDComplexMatrix2DTest.assertEquals((double)fArray[n + 1], (double)dArray[1], (double)this.TOL);
                n += 2;
            }
        }
    }

    public void testAssignDoubleArrayArray() {
        int n;
        int n2;
        double[][] dArray = new double[this.NCOLUMNS][2 * this.NROWS];
        for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
            for (n = 0; n < 2 * this.NROWS; ++n) {
                dArray[n2][n] = Math.random();
            }
        }
        this.A.assign(dArray);
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            for (n = 0; n < this.A.rows(); ++n) {
                double[] dArray2 = this.A.getQuick(n, n2);
                DenseColumnDComplexMatrix2DTest.assertEquals((double)dArray[n2][2 * n], (double)dArray2[0], (double)this.TOL);
                DenseColumnDComplexMatrix2DTest.assertEquals((double)dArray[n2][2 * n + 1], (double)dArray2[1], (double)this.TOL);
            }
        }
    }

    public void testFft2() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        ((DenseColumnDComplexMatrix2D)this.A).fft2();
        ((DenseColumnDComplexMatrix2D)this.A).ifft2(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                this.assertEquals(dComplexMatrix2D.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testFftColumns() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        ((DenseColumnDComplexMatrix2D)this.A).fftColumns();
        ((DenseColumnDComplexMatrix2D)this.A).ifftColumns(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                this.assertEquals(dComplexMatrix2D.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testFftRows() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        ((DenseColumnDComplexMatrix2D)this.A).fftRows();
        ((DenseColumnDComplexMatrix2D)this.A).ifftRows(true);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                this.assertEquals(dComplexMatrix2D.getQuick(i, j), this.A.getQuick(i, j), this.TOL);
            }
        }
    }
}

