/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalLongMatrix2D(long[][] lArray, int n) {
        this(lArray.length, lArray.length == 0 ? 0 : lArray[0].length, n);
        this.assign(lArray);
    }

    public DiagonalLongMatrix2D(int n, int n2, int n3) {
        int n4;
        int n5;
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (n3 < -n + 1 || n3 > n2 - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = n3;
        this.dlength = n3 == 0 ? Math.min(n, n2) : (n3 > 0 ? (n >= n2 ? n2 - n3 : (n3 <= (n5 = n2 - n) ? n : n - (n3 - n5))) : (n >= n2 ? (-n3 <= (n4 = n - n2) ? n2 : n2 + n3 + n4) : n + n3));
        this.elements = new long[this.dlength];
    }

    public LongMatrix2D assign(LongFunction longFunction) {
        if (longFunction instanceof LongMult) {
            long l = ((LongMult)longFunction).multiplicator;
            if (l == 1L) {
                return this;
            }
            if (l == 0L) {
                return this.assign(0L);
            }
            if (l != l) {
                return this.assign(l);
            }
            int n = this.dlength;
            while (--n >= 0) {
                int n2 = n;
                this.elements[n2] = this.elements[n2] * l;
            }
        } else {
            int n = this.dlength;
            while (--n >= 0) {
                this.elements[n] = longFunction.apply(this.elements[n]);
            }
        }
        return this;
    }

    public LongMatrix2D assign(long l) {
        int n = this.dlength;
        while (--n >= 0) {
            this.elements[n] = l;
        }
        return this;
    }

    public LongMatrix2D assign(final long[] lArray) {
        if (lArray.length != this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + lArray.length + " dlength=" + this.dlength);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.dlength);
            Future[] futureArray = new Future[n];
            int n2 = this.dlength / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DiagonalLongMatrix2D.this.elements[i] = lArray[i];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.dlength;
            while (--n5 >= 0) {
                this.elements[n5] = lArray[n5];
            }
        }
        return this;
    }

    public LongMatrix2D assign(long[][] lArray) {
        int n;
        int n2;
        if (lArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + lArray.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            n2 = 0;
            n = this.dindex;
        } else {
            n2 = -this.dindex;
            n = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (lArray[i].length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + lArray[n2].length + "columns()=" + this.columns());
            }
            this.elements[i] = lArray[n2++][n++];
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D) {
        if (longMatrix2D == this) {
            return this;
        }
        this.checkShape(longMatrix2D);
        if (longMatrix2D instanceof DiagonalLongMatrix2D) {
            DiagonalLongMatrix2D diagonalLongMatrix2D = (DiagonalLongMatrix2D)longMatrix2D;
            if (this.dindex != diagonalLongMatrix2D.dindex || this.dlength != diagonalLongMatrix2D.dlength) {
                throw new IllegalArgumentException("source is DiagonalLongMatrix2D with different diagonal stored.");
            }
            System.arraycopy(diagonalLongMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(longMatrix2D);
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D, final LongLongFunction longLongFunction) {
        this.checkShape(longMatrix2D);
        if (longMatrix2D instanceof DiagonalLongMatrix2D) {
            long l;
            DiagonalLongMatrix2D diagonalLongMatrix2D = (DiagonalLongMatrix2D)longMatrix2D;
            if (this.dindex != diagonalLongMatrix2D.dindex || this.dlength != diagonalLongMatrix2D.dlength) {
                throw new IllegalArgumentException("y is DiagonalLongMatrix2D with different diagonal stored.");
            }
            if (longLongFunction instanceof LongPlusMultSecond && (l = ((LongPlusMultSecond)longLongFunction).multiplicator) == 0L) {
                return this;
            }
            final long[] lArray = diagonalLongMatrix2D.elements;
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.dlength);
                Future[] futureArray = new Future[n];
                int n2 = this.dlength / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (longLongFunction instanceof LongPlusMultSecond) {
                                long l = ((LongPlusMultSecond)longLongFunction).multiplicator;
                                if (l == 1L) {
                                    for (int i = n3; i < n4; ++i) {
                                        int n = i;
                                        DiagonalLongMatrix2D.this.elements[n] = DiagonalLongMatrix2D.this.elements[n] + lArray[i];
                                    }
                                } else {
                                    for (int i = n3; i < n4; ++i) {
                                        DiagonalLongMatrix2D.this.elements[i] = DiagonalLongMatrix2D.this.elements[i] + l * lArray[i];
                                    }
                                }
                            } else if (longLongFunction == LongFunctions.mult) {
                                for (int i = n3; i < n4; ++i) {
                                    DiagonalLongMatrix2D.this.elements[i] = DiagonalLongMatrix2D.this.elements[i] * lArray[i];
                                }
                            } else if (longLongFunction == LongFunctions.div) {
                                for (int i = n3; i < n4; ++i) {
                                    DiagonalLongMatrix2D.this.elements[i] = DiagonalLongMatrix2D.this.elements[i] / lArray[i];
                                }
                            } else {
                                for (int i = n3; i < n4; ++i) {
                                    DiagonalLongMatrix2D.this.elements[i] = longLongFunction.apply(DiagonalLongMatrix2D.this.elements[i], lArray[i]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else if (longLongFunction instanceof LongPlusMultSecond) {
                long l2 = ((LongPlusMultSecond)longLongFunction).multiplicator;
                if (l2 == 1L) {
                    int n5 = this.dlength;
                    while (--n5 >= 0) {
                        int n6 = n5;
                        this.elements[n6] = this.elements[n6] + lArray[n5];
                    }
                } else {
                    int n7 = this.dlength;
                    while (--n7 >= 0) {
                        this.elements[n7] = this.elements[n7] + l2 * lArray[n7];
                    }
                }
            } else if (longLongFunction == LongFunctions.mult) {
                int n8 = this.dlength;
                while (--n8 >= 0) {
                    this.elements[n8] = this.elements[n8] * lArray[n8];
                }
            } else if (longLongFunction == LongFunctions.div) {
                int n9 = this.dlength;
                while (--n9 >= 0) {
                    this.elements[n9] = this.elements[n9] / lArray[n9];
                }
            } else {
                int n10 = this.dlength;
                while (--n10 >= 0) {
                    this.elements[n10] = longLongFunction.apply(this.elements[n10], lArray[n10]);
                }
            }
            return this;
        }
        return super.assign(longMatrix2D, longLongFunction);
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.dlength);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.dlength / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.dlength : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (DiagonalLongMatrix2D.this.elements[i] == 0L) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                if (this.elements[i] == 0L) continue;
                ++n;
            }
        }
        return n;
    }

    public long[] elements() {
        return this.elements;
    }

    public boolean equals(long l) {
        for (int i = 0; i < this.dlength; ++i) {
            long l2 = this.elements[i];
            long l3 = l - l2;
            if (l3 == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof DiagonalLongMatrix2D) {
            DiagonalLongMatrix2D diagonalLongMatrix2D = (DiagonalLongMatrix2D)object;
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            int n = this.rows();
            int n2 = this.columns();
            if (n2 != diagonalLongMatrix2D.columns() || n != diagonalLongMatrix2D.rows()) {
                return false;
            }
            if (this.dindex != diagonalLongMatrix2D.dindex || this.dlength != diagonalLongMatrix2D.dlength) {
                return false;
            }
            long[] lArray = diagonalLongMatrix2D.elements;
            for (int i = 0; i < this.dlength; ++i) {
                long l = lArray[i];
                long l2 = this.elements[i];
                long l3 = l - l2;
                if (l3 == 0L) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public LongMatrix2D forEachNonZero(IntIntLongFunction intIntLongFunction) {
        int n = this.dlength;
        while (--n >= 0) {
            long l = this.elements[n];
            if (l == 0L) continue;
            this.elements[n] = intIntLongFunction.apply(n, n, l);
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    public long[] getMaxLocation() {
        int n;
        int n2;
        int n3 = 0;
        long l = 0L;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.dlength);
            Future[] futureArray = new Future[n4];
            long[][] lArray = new long[n4][2];
            int n6 = this.dlength / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.dlength : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = n7;
                        long l = DiagonalLongMatrix2D.this.elements[n];
                        for (int i = n7 + 1; i < n8; ++i) {
                            long l2 = DiagonalLongMatrix2D.this.elements[i];
                            if (l >= l2) continue;
                            l = l2;
                            n = i;
                        }
                        return new long[]{l, n, n};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    lArray[n5] = (long[])futureArray[n5].get();
                }
                l = lArray[0][0];
                n3 = (int)lArray[0][1];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (l >= lArray[n5][0]) continue;
                    l = lArray[n5][0];
                    n3 = (int)lArray[n5][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.elements[0];
            for (int i = 1; i < this.dlength; ++i) {
                long l2 = this.elements[i];
                if (l >= l2) continue;
                l = l2;
                n3 = i;
            }
        }
        if (this.dindex > 0) {
            n2 = n3;
            n = n3 + this.dindex;
        } else if (this.dindex < 0) {
            n2 = n3 - this.dindex;
            n = n3;
        } else {
            n2 = n3;
            n = n3;
        }
        return new long[]{l, n2, n};
    }

    public long[] getMinLocation() {
        int n;
        int n2;
        int n3 = 0;
        long l = 0L;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.dlength);
            Future[] futureArray = new Future[n4];
            long[][] lArray = new long[n4][2];
            int n6 = this.dlength / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.dlength : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = n7;
                        long l = DiagonalLongMatrix2D.this.elements[n];
                        for (int i = n7 + 1; i < n8; ++i) {
                            long l2 = DiagonalLongMatrix2D.this.elements[i];
                            if (l <= l2) continue;
                            l = l2;
                            n = i;
                        }
                        return new long[]{l, n, n};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    lArray[n5] = (long[])futureArray[n5].get();
                }
                l = lArray[0][0];
                n3 = (int)lArray[0][1];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (l <= lArray[n5][0]) continue;
                    l = lArray[n5][0];
                    n3 = (int)lArray[n5][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.elements[0];
            for (int i = 1; i < this.dlength; ++i) {
                long l2 = this.elements[i];
                if (l <= l2) continue;
                l = l2;
                n3 = i;
            }
        }
        if (this.dindex > 0) {
            n2 = n3;
            n = n3 + this.dindex;
        } else if (this.dindex < 0) {
            n2 = n3 - this.dindex;
            n = n3;
        } else {
            n2 = n3;
            n = n3;
        }
        return new long[]{l, n2, n};
    }

    public long getQuick(int n, int n2) {
        if (this.dindex >= 0) {
            if (n2 < this.dindex) {
                return 0L;
            }
            if (n < this.dlength && n + this.dindex == n2) {
                return this.elements[n];
            }
            return 0L;
        }
        if (n < -this.dindex) {
            return 0L;
        }
        if (n2 < this.dlength && n + this.dindex == n2) {
            return this.elements[n2];
        }
        return 0L;
    }

    public LongMatrix2D like(int n, int n2) {
        return new SparseLongMatrix2D(n, n2);
    }

    public LongMatrix1D like1D(int n) {
        return new SparseLongMatrix1D(n);
    }

    public void setQuick(int n, int n2, long l) {
        if (this.dindex >= 0) {
            if (n2 >= this.dindex && n < this.dlength && n + this.dindex == n2) {
                this.elements[n] = l;
            }
        } else if (n >= -this.dindex && n2 < this.dlength && n + this.dindex == n2) {
            this.elements[n2] = l;
        }
    }

    public LongMatrix1D zMult(LongMatrix1D longMatrix1D, LongMatrix1D longMatrix1D2, long l, long l2, boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = longMatrix1D2 == null;
        if (longMatrix1D2 == null) {
            longMatrix1D2 = new DenseLongMatrix1D(n);
        }
        if (!(this.isNoView && longMatrix1D instanceof DenseLongMatrix1D && longMatrix1D2 instanceof DenseLongMatrix1D)) {
            return super.zMult(longMatrix1D, longMatrix1D2, l, l2, bl);
        }
        if ((long)n2 != longMatrix1D.size() || (long)n > longMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + longMatrix1D.toStringShort() + ", " + longMatrix1D2.toStringShort());
        }
        if (!bl2 && l2 != 1L) {
            longMatrix1D2.assign(LongFunctions.mult(l2));
        }
        DenseLongMatrix1D denseLongMatrix1D = (DenseLongMatrix1D)longMatrix1D2;
        long[] lArray = denseLongMatrix1D.elements;
        int n3 = denseLongMatrix1D.stride();
        int n4 = (int)longMatrix1D2.index(0);
        DenseLongMatrix1D denseLongMatrix1D2 = (DenseLongMatrix1D)longMatrix1D;
        long[] lArray2 = denseLongMatrix1D2.elements;
        int n5 = denseLongMatrix1D2.stride();
        int n6 = (int)longMatrix1D.index(0);
        if (lArray2 == null || lArray == null) {
            throw new InternalError();
        }
        if (!bl) {
            if (this.dindex >= 0) {
                int n7 = this.dlength;
                while (--n7 >= 0) {
                    int n8 = n4 + n3 * n7;
                    lArray[n8] = lArray[n8] + l * this.elements[n7] * lArray2[this.dindex + n6 + n5 * n7];
                }
            } else {
                int n9 = this.dlength;
                while (--n9 >= 0) {
                    int n10 = -this.dindex + n4 + n3 * n9;
                    lArray[n10] = lArray[n10] + l * this.elements[n9] * lArray2[n6 + n5 * n9];
                }
            }
        } else if (this.dindex >= 0) {
            int n11 = this.dlength;
            while (--n11 >= 0) {
                int n12 = this.dindex + n4 + n3 * n11;
                lArray[n12] = lArray[n12] + l * this.elements[n11] * lArray2[n6 + n5 * n11];
            }
        } else {
            int n13 = this.dlength;
            while (--n13 >= 0) {
                int n14 = n4 + n3 * n13;
                lArray[n14] = lArray[n14] + l * this.elements[n13] * lArray2[-this.dindex + n6 + n5 * n13];
            }
        }
        return longMatrix1D2;
    }

    protected LongMatrix2D getContent() {
        return this;
    }
}

