/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.IntIntObjectFunction;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedDenseColumnObjectMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseColumnObjectMatrix2D
extends ObjectMatrix2D {
    static final long serialVersionUID = 1020177651L;
    protected Object[] elements;

    public DenseColumnObjectMatrix2D(Object[][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length);
        this.assign(objectArray);
    }

    public DenseColumnObjectMatrix2D(int n, int n2) {
        this.setUp(n, n2, 0, 0, 1, n);
        this.elements = new Object[n * n2];
    }

    public DenseColumnObjectMatrix2D(int n, int n2, Object[] objectArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = objectArray;
        this.isNoView = !bl;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        Object object = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectFunction.apply(DenseColumnObjectMatrix2D.this.elements[n + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n4 - 1) * DenseColumnObjectMatrix2D.this.columnStride]);
                        int n6 = 1;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n + n2 * DenseColumnObjectMatrix2D.this.columnStride;
                            int n42 = DenseColumnObjectMatrix2D.this.rows - n6;
                            while (--n42 >= 0) {
                                object = objectObjectFunction.apply(object, objectFunction.apply(DenseColumnObjectMatrix2D.this.elements[n42 * DenseColumnObjectMatrix2D.this.rowStride + n3]));
                            }
                            n6 = 0;
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectFunction.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int n6 = 1;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n + n7 * this.columnStride;
                int n9 = this.rows - n6;
                while (--n9 >= 0) {
                    object = objectObjectFunction.apply(object, objectFunction.apply(this.elements[n9 * this.rowStride + n8]));
                }
                n6 = 0;
            }
        }
        return object;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction, final ObjectProcedure objectProcedure) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        Object object = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = DenseColumnObjectMatrix2D.this.elements[n + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n4 - 1) * DenseColumnObjectMatrix2D.this.columnStride];
                        Object object2 = 0;
                        if (objectProcedure.apply(object)) {
                            object2 = objectFunction.apply(object);
                        }
                        int n6 = 1;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n + n2 * DenseColumnObjectMatrix2D.this.columnStride;
                            int n42 = DenseColumnObjectMatrix2D.this.rows - n6;
                            while (--n42 >= 0) {
                                object = DenseColumnObjectMatrix2D.this.elements[n42 * DenseColumnObjectMatrix2D.this.rowStride + n3];
                                if (!objectProcedure.apply(object)) continue;
                                object2 = objectObjectFunction.apply(object2, objectFunction.apply(object));
                            }
                            n6 = 0;
                        }
                        return object2;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            Object object2 = this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            if (objectProcedure.apply(object2)) {
                object = objectFunction.apply(object2);
            }
            int n6 = 1;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n + n7 * this.columnStride;
                int n9 = this.rows - n6;
                while (--n9 >= 0) {
                    object2 = this.elements[n9 * this.rowStride + n8];
                    if (!objectProcedure.apply(object2)) continue;
                    object = objectObjectFunction.apply(object, objectFunction.apply(object2));
                }
                n6 = 0;
            }
        }
        return object;
    }

    public Object aggregate(final ObjectObjectFunction objectObjectFunction, final ObjectFunction objectFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        int n2 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        Object object = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, this.columns);
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = n2 - i * n4;
                final int n6 = i == n3 - 1 ? 0 : n5 - n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectFunction.apply(DenseColumnObjectMatrix2D.this.elements[n + nArray[n5 - 1] * DenseColumnObjectMatrix2D.this.rowStride + nArray2[n5 - 1] * DenseColumnObjectMatrix2D.this.columnStride]);
                        int n2 = n5 - 1;
                        while (--n2 >= n6) {
                            object = objectObjectFunction.apply(object, objectFunction.apply(DenseColumnObjectMatrix2D.this.elements[n + nArray[n2] * DenseColumnObjectMatrix2D.this.rowStride + nArray2[n2] * DenseColumnObjectMatrix2D.this.columnStride]));
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            object = objectFunction.apply(this.elements[n + nArray[n2 - 1] * this.rowStride + nArray2[n2 - 1] * this.columnStride]);
            int n7 = n2 - 1;
            while (--n7 >= 0) {
                object = objectObjectFunction.apply(object, objectFunction.apply(this.elements[n + nArray[n7] * this.rowStride + nArray2[n7] * this.columnStride]));
            }
        }
        return object;
    }

    public Object aggregate(ObjectMatrix2D objectMatrix2D, final ObjectObjectFunction objectObjectFunction, final ObjectObjectFunction objectObjectFunction2) {
        if (!(objectMatrix2D instanceof DenseColumnObjectMatrix2D)) {
            return super.aggregate(objectMatrix2D, objectObjectFunction, objectObjectFunction2);
        }
        this.checkShape(objectMatrix2D);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)objectMatrix2D.index(0, 0);
        final int n3 = objectMatrix2D.rowStride();
        final int n4 = objectMatrix2D.columnStride();
        final Object[] objectArray = (Object[])objectMatrix2D.elements();
        Object object = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object object = objectObjectFunction2.apply(DenseColumnObjectMatrix2D.this.elements[n + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n7 - 1) * DenseColumnObjectMatrix2D.this.columnStride], objectArray[n2 + (DenseColumnObjectMatrix2D.this.rows - 1) * n3 + (n7 - 1) * n4]);
                        int n6 = 1;
                        int n22 = n7;
                        while (--n22 >= n8) {
                            int n32 = n + n22 * DenseColumnObjectMatrix2D.this.columnStride;
                            int n42 = n2 + n22 * n4;
                            int n5 = DenseColumnObjectMatrix2D.this.rows - n6;
                            while (--n5 >= 0) {
                                object = objectObjectFunction.apply(object, objectObjectFunction2.apply(DenseColumnObjectMatrix2D.this.elements[n5 * DenseColumnObjectMatrix2D.this.rowStride + n32], objectArray[n5 * n3 + n42]));
                            }
                            n6 = 0;
                        }
                        return object;
                    }
                });
            }
            object = ConcurrencyUtils.waitForCompletion(futureArray, objectObjectFunction);
        } else {
            int n9 = 1;
            object = objectObjectFunction2.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride], objectArray[n2 + (this.rows - 1) * n3 + (this.columns - 1) * n4]);
            int n10 = this.columns;
            while (--n10 >= 0) {
                int n11 = n + n10 * this.columnStride;
                int n12 = n2 + n10 * n4;
                int n13 = this.rows - n9;
                while (--n13 >= 0) {
                    object = objectObjectFunction.apply(object, objectObjectFunction2.apply(this.elements[n13 * this.rowStride + n11], objectArray[n13 * n3 + n12]));
                }
                n9 = 0;
            }
        }
        return object;
    }

    public ObjectMatrix2D assign(final ObjectFunction objectFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n4 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnObjectMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                DenseColumnObjectMatrix2D.this.elements[n3] = objectFunction.apply(DenseColumnObjectMatrix2D.this.elements[n3]);
                                n3 -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    this.elements[n8] = objectFunction.apply(this.elements[n8]);
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure objectProcedure, final ObjectFunction objectFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n4 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnObjectMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                Object object = DenseColumnObjectMatrix2D.this.elements[n3];
                                if (objectProcedure.apply(object)) {
                                    DenseColumnObjectMatrix2D.this.elements[n3] = objectFunction.apply(object);
                                }
                                n3 -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    Object object = this.elements[n8];
                    if (objectProcedure.apply(object)) {
                        this.elements[n8] = objectFunction.apply(object);
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure objectProcedure, final Object object) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n4 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnObjectMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                Object object2 = DenseColumnObjectMatrix2D.this.elements[n3];
                                if (objectProcedure.apply(object2)) {
                                    DenseColumnObjectMatrix2D.this.elements[n3] = object;
                                }
                                n3 -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    Object object2 = this.elements[n8];
                    if (objectProcedure.apply(object2)) {
                        this.elements[n8] = object;
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object object) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n4 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnObjectMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                DenseColumnObjectMatrix2D.this.elements[n3] = object;
                                n3 -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    this.elements[n8] = object;
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[] objectArray) {
        if ((long)objectArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + objectArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n3 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = this.columns - i * n3;
                    final int n5 = i == n - 1 ? 0 : n4 - n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n2 + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n4 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                            int n22 = DenseColumnObjectMatrix2D.this.rows - 1 + (n4 - 1) * DenseColumnObjectMatrix2D.this.rows;
                            int n3 = n4;
                            while (--n3 >= n5) {
                                int n42 = n;
                                int n52 = DenseColumnObjectMatrix2D.this.rows;
                                while (--n52 >= 0) {
                                    DenseColumnObjectMatrix2D.this.elements[n42] = objectArray[n22--];
                                    n42 -= DenseColumnObjectMatrix2D.this.rowStride;
                                }
                                n -= DenseColumnObjectMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int n7 = objectArray.length - 1;
                int n8 = this.columns;
                while (--n8 >= 0) {
                    int n9 = n6;
                    int n10 = this.rows;
                    while (--n10 >= 0) {
                        this.elements[n9] = objectArray[n7--];
                        n9 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[][] objectArray) {
        if (objectArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + objectArray.length + "columns()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (n4 - 1) * DenseColumnObjectMatrix2D.this.rowStride + (DenseColumnObjectMatrix2D.this.columns - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n22 = n4;
                        while (--n22 >= n5) {
                            Object[] objectArray2 = objectArray[n22];
                            if (objectArray2.length != DenseColumnObjectMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: column=" + objectArray2.length + "columns()=" + DenseColumnObjectMatrix2D.this.columns());
                            }
                            int n3 = n;
                            int n42 = DenseColumnObjectMatrix2D.this.columns;
                            while (--n42 >= 0) {
                                DenseColumnObjectMatrix2D.this.elements[n3] = objectArray2[n42];
                                n3 -= DenseColumnObjectMatrix2D.this.columnStride;
                            }
                            n -= DenseColumnObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.rows;
            while (--n7 >= 0) {
                Object[] objectArray2 = objectArray[n7];
                if (objectArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: column=" + objectArray2.length + "columns()=" + this.columns());
                }
                int n8 = n6;
                int n9 = this.columns;
                while (--n9 >= 0) {
                    this.elements[n8] = objectArray2[n9];
                    n8 -= this.columnStride;
                }
                n6 -= this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D) {
        if (!(objectMatrix2D instanceof DenseColumnObjectMatrix2D)) {
            super.assign(objectMatrix2D);
            return this;
        }
        DenseColumnObjectMatrix2D denseColumnObjectMatrix2D = (DenseColumnObjectMatrix2D)objectMatrix2D;
        if (denseColumnObjectMatrix2D == this) {
            return this;
        }
        this.checkShape(denseColumnObjectMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseColumnObjectMatrix2D.isNoView) {
            System.arraycopy(denseColumnObjectMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseColumnObjectMatrix2D)) {
            ObjectMatrix2D objectMatrix2D2 = denseColumnObjectMatrix2D.copy();
            if (!(objectMatrix2D2 instanceof DenseColumnObjectMatrix2D)) {
                super.assign(denseColumnObjectMatrix2D);
                return this;
            }
            denseColumnObjectMatrix2D = (DenseColumnObjectMatrix2D)objectMatrix2D2;
        }
        final int n2 = (int)denseColumnObjectMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnObjectMatrix2D.columnStride;
        final int n5 = denseColumnObjectMatrix2D.rowStride;
        final Object[] objectArray = denseColumnObjectMatrix2D.elements;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n6 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n7 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n22 = n2 + (DenseColumnObjectMatrix2D.this.rows - 1) * n5 + (n7 - 1) * n4;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n;
                            int n52 = n22;
                            int n6 = DenseColumnObjectMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                DenseColumnObjectMatrix2D.this.elements[n42] = objectArray[n52];
                                n42 -= DenseColumnObjectMatrix2D.this.rowStride;
                                n52 -= n5;
                            }
                            n -= DenseColumnObjectMatrix2D.this.columnStride;
                            n22 -= n4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n2 + (this.rows - 1) * n5 + (this.columns - 1) * n4;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    this.elements[n12] = objectArray[n13];
                    n12 -= this.rowStride;
                    n13 -= n5;
                }
                n9 -= this.columnStride;
                n10 -= n4;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D, final ObjectObjectFunction objectObjectFunction) {
        if (!(objectMatrix2D instanceof DenseColumnObjectMatrix2D)) {
            super.assign(objectMatrix2D, objectObjectFunction);
            return this;
        }
        DenseColumnObjectMatrix2D denseColumnObjectMatrix2D = (DenseColumnObjectMatrix2D)objectMatrix2D;
        this.checkShape(objectMatrix2D);
        final Object[] objectArray = denseColumnObjectMatrix2D.elements;
        final int n = (int)denseColumnObjectMatrix2D.index(0, 0);
        final int n2 = (int)this.index(0, 0);
        final int n3 = denseColumnObjectMatrix2D.columnStride;
        final int n4 = denseColumnObjectMatrix2D.rowStride;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n2 + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n7 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n22 = n + (DenseColumnObjectMatrix2D.this.rows - 1) * n4 + (n7 - 1) * n3;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n9;
                            int n5 = n22;
                            int n6 = DenseColumnObjectMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                DenseColumnObjectMatrix2D.this.elements[n42] = objectObjectFunction.apply(DenseColumnObjectMatrix2D.this.elements[n42], objectArray[n5]);
                                n42 -= DenseColumnObjectMatrix2D.this.rowStride;
                                n5 -= n4;
                            }
                            n9 -= DenseColumnObjectMatrix2D.this.columnStride;
                            n22 -= n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n + (this.rows - 1) * n4 + (this.columns - 1) * n3;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    this.elements[n12] = objectObjectFunction.apply(this.elements[n12], objectArray[n13]);
                    n12 -= this.rowStride;
                    n13 -= n4;
                }
                n9 -= this.columnStride;
                n10 -= n3;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D, final ObjectObjectFunction objectObjectFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(objectMatrix2D);
        if (!(objectMatrix2D instanceof DenseColumnObjectMatrix2D)) {
            super.assign(objectMatrix2D, objectObjectFunction);
            return this;
        }
        DenseColumnObjectMatrix2D denseColumnObjectMatrix2D = (DenseColumnObjectMatrix2D)objectMatrix2D;
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final Object[] objectArray = denseColumnObjectMatrix2D.elements();
        final int n2 = (int)denseColumnObjectMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnObjectMatrix2D.columnStride();
        final int n5 = denseColumnObjectMatrix2D.rowStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.columns);
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = n - i * n7;
                final int n9 = i == n6 - 1 ? 0 : n8 - n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n8;
                        while (--n >= n9) {
                            int n22 = n3 + nArray[n] * DenseColumnObjectMatrix2D.this.rowStride + nArray2[n] * DenseColumnObjectMatrix2D.this.columnStride;
                            int n32 = n2 + nArray[n] * n5 + nArray2[n] * n4;
                            DenseColumnObjectMatrix2D.this.elements[n22] = objectObjectFunction.apply(DenseColumnObjectMatrix2D.this.elements[n22], objectArray[n32]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n;
            while (--n10 >= 0) {
                int n11 = n3 + nArray[n10] * this.rowStride + nArray2[n10] * this.columnStride;
                int n12 = n2 + nArray[n10] * n5 + nArray2[n10] * n4;
                this.elements[n11] = objectObjectFunction.apply(this.elements[n11], objectArray[n12]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.columns / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = this.columns - n4 * n5;
                final int n7 = n4 == n2 - 1 ? 0 : n6 - n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n6 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n32 = n6;
                        while (--n32 >= n7) {
                            int n4 = n2;
                            int n5 = DenseColumnObjectMatrix2D.this.rows;
                            while (--n5 >= 0) {
                                if (DenseColumnObjectMatrix2D.this.elements[n4] != null) {
                                    ++n;
                                }
                                n4 -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            n2 -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n9 = this.columns;
            while (--n9 >= 0) {
                int n10 = n8;
                int n11 = this.rows;
                while (--n11 >= 0) {
                    if (this.elements[n10] != null) {
                        ++n;
                    }
                    n10 -= this.rowStride;
                }
                n8 -= this.columnStride;
            }
        }
        return n;
    }

    public Object[] elements() {
        return this.elements;
    }

    public ObjectMatrix2D forEachNonZero(final IntIntObjectFunction intIntObjectFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n4 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnObjectMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                Object object = DenseColumnObjectMatrix2D.this.elements[n3];
                                if (object != null) {
                                    DenseColumnObjectMatrix2D.this.elements[n3] = intIntObjectFunction.apply(n42, n2, object);
                                }
                                n3 -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    Object object = this.elements[n8];
                    if (object != null) {
                        this.elements[n8] = intIntObjectFunction.apply(n9, n7, object);
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public DenseObjectMatrix2D getRowMajor() {
        DenseObjectMatrix2D denseObjectMatrix2D = new DenseObjectMatrix2D(this.rows, this.columns);
        final int n = (int)denseObjectMatrix2D.index(0, 0);
        final int n2 = denseObjectMatrix2D.rowStride();
        final int n3 = denseObjectMatrix2D.columnStride();
        final Object[] objectArray = denseObjectMatrix2D.elements();
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n4 + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n7 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n22 = n + (DenseColumnObjectMatrix2D.this.rows - 1) * n2 + (n7 - 1) * n3;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n9;
                            int n5 = n22;
                            int n6 = DenseColumnObjectMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                objectArray[n5] = DenseColumnObjectMatrix2D.this.elements[n42];
                                n42 -= DenseColumnObjectMatrix2D.this.rowStride;
                                n5 -= n2;
                            }
                            n9 -= DenseColumnObjectMatrix2D.this.columnStride;
                            n22 -= n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n + (this.rows - 1) * n2 + (this.columns - 1) * n3;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    objectArray[n13] = this.elements[n12];
                    n12 -= this.rowStride;
                    n13 -= n2;
                }
                n9 -= this.columnStride;
                n10 -= n3;
            }
        }
        return denseObjectMatrix2D;
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, ObjectArrayList objectArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        objectArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                Object object = this.elements[n2];
                if (object != null) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    objectArrayList.add(object);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public Object getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new DenseColumnObjectMatrix2D(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return new DenseObjectMatrix1D(n);
    }

    public void setQuick(int n, int n2, Object object) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = object;
    }

    public Object[][] toArray() {
        final Object[][] objectArray = new Object[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n4 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int n22 = n4;
                        while (--n22 >= n5) {
                            int n3 = n;
                            int n42 = DenseColumnObjectMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                objectArray[n42][n22] = DenseColumnObjectMatrix2D.this.elements[n3];
                                n3 -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            n -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    objectArray[n9][n7] = this.elements[n8];
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return objectArray;
    }

    public ObjectMatrix1D vectorize() {
        int n = (int)this.size();
        DenseObjectMatrix1D denseObjectMatrix1D = new DenseObjectMatrix1D(n);
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((ObjectMatrix1D)denseObjectMatrix1D).elements(), 0, n);
        } else {
            final int n2 = (int)this.index(0, 0);
            final int n3 = (int)((AbstractMatrix1D)denseObjectMatrix1D).index(0);
            final int n4 = denseObjectMatrix1D.stride();
            final Object[] objectArray = (Object[])((ObjectMatrix1D)denseObjectMatrix1D).elements();
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n5 = Math.min(n5, this.columns);
                Future[] futureArray = new Future[n5];
                int n6 = this.columns / n5;
                for (int i = 0; i < n5; ++i) {
                    final int n7 = this.columns - i * n6;
                    final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                    final int n9 = n - i * n6 * this.rows;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n2 + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (n7 - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                            int n22 = n3 + (n9 - 1) * n4;
                            int n32 = n7;
                            while (--n32 >= n8) {
                                int n42 = n;
                                int n5 = DenseColumnObjectMatrix2D.this.rows;
                                while (--n5 >= 0) {
                                    objectArray[n22] = DenseColumnObjectMatrix2D.this.elements[n42];
                                    n42 -= DenseColumnObjectMatrix2D.this.rowStride;
                                    n22 -= n4;
                                }
                                n -= DenseColumnObjectMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int n11 = n3 + n - 1;
                int n12 = this.columns;
                while (--n12 >= 0) {
                    int n13 = n10;
                    int n14 = this.rows;
                    while (--n14 >= 0) {
                        objectArray[n11] = this.elements[n13];
                        n13 -= this.rowStride;
                        --n11;
                    }
                    n10 -= this.columnStride;
                }
            }
        }
        return denseObjectMatrix1D;
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D instanceof SelectedDenseColumnObjectMatrix2D) {
            SelectedDenseColumnObjectMatrix2D selectedDenseColumnObjectMatrix2D = (SelectedDenseColumnObjectMatrix2D)objectMatrix2D;
            return this.elements == selectedDenseColumnObjectMatrix2D.elements;
        }
        if (objectMatrix2D instanceof DenseColumnObjectMatrix2D) {
            DenseColumnObjectMatrix2D denseColumnObjectMatrix2D = (DenseColumnObjectMatrix2D)objectMatrix2D;
            return this.elements == denseColumnObjectMatrix2D.elements;
        }
        return false;
    }

    protected ObjectMatrix1D like1D(int n, int n2, int n3) {
        return new DenseObjectMatrix1D(n, this.elements, n2, n3, true);
    }

    protected ObjectMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseColumnObjectMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

