% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{participants}
\alias{participants}
\title{Participants contributing to an analysis}
\usage{
participants(result, analysisId)
}
\arguments{
\item{result}{Result object}

\item{analysisId}{ID of a specific analysis to return participants for}
}
\value{
References to tables with the study participants contributing to
a given analysis
}
\description{
Participants contributing to an analysis
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 200)
cdm$denominator <- generateDenominatorCohortSet(cdm)
incidence <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome",
  interval = "overall"
)
participants(result = incidence, analysisId = 1)
}
}
