% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prevalenceSet}
\alias{prevalenceSet}
\title{Settings associated with a prevalence analysis}
\usage{
prevalenceSet(result)
}
\arguments{
\item{result}{Result for which to get settings}
}
\value{
tibble with settings used when estimating prevalence
}
\description{
Settings associated with a prevalence analysis
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 200)
cdm$denominator <- generateDenominatorCohortSet(cdm)
prev <- estimatePointPrevalence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
prevalenceSet(prev)
}
}
