% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateDenominatorCohortSet.R
\name{generateTargetDenominatorCohortSet}
\alias{generateTargetDenominatorCohortSet}
\title{Identify a set of denominator populations using a target cohort}
\usage{
generateTargetDenominatorCohortSet(
  cdm,
  name,
  targetCohortTable,
  targetCohortId = NULL,
  cohortDateRange = as.Date(c(NA, NA)),
  timeAtRisk = c(0, Inf),
  ageGroup = list(c(0, 150)),
  sex = "Both",
  daysPriorObservation = 0,
  requirementInteractions = TRUE
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{name}{Name of the cohort table to be created.}

\item{targetCohortTable}{A cohort table in the cdm reference to use
to limit cohort entry and exit (with individuals only contributing to a
cohort when they are contributing to the cohort in the target table).}

\item{targetCohortId}{The cohort definition id for the cohort of interest
in the target table. If targetCohortTable is specified, a single targetCohortId
must also be specified.}

\item{cohortDateRange}{Two dates. The first indicating the earliest cohort
start date and the second indicating the latest possible cohort end date. If
NULL or the first date is set as missing, the earliest observation_start_date
in the observation_period table will be used for the former. If  NULL or the
second date is set as missing, the latest observation_end_date in the
observation_period table will be used for the latter.}

\item{timeAtRisk}{Lower and upper bound for the time at risk window to apply
relative to the target cohort entry. A value of list(c(0, 30), c(31, 60))
would, for example, create one set of denominator cohorts with time up to
the 30 days following target cohort entry and another set with time from
31 days following entry to 60 days. If time at risk start is after target
cohort exit and/ or observation period end then no time will be contributed.
If time at risk end is after cohort exit and/ or observation period, then
only time up to these will be contributed.}

\item{ageGroup}{A list of age groups for which cohorts will be generated. A
value of \code{list(c(0,17), c(18,30))} would, for example, lead to the creation
of cohorts for those aged from 0 to 17, and from 18 to 30. In this example
an individual turning 18 during the time period would appear in both
cohorts (leaving the first cohort the day before their 18th birthday and
entering the second from the day of their 18th birthday).}

\item{sex}{Sex of the cohorts. This can be one or more of: \code{"Male"},
\code{"Female"}, or \code{"Both"}.}

\item{daysPriorObservation}{The number of days of prior observation observed in
the database required for an individual to start contributing time in
a cohort.}

\item{requirementInteractions}{If TRUE, cohorts will be created for
all combinations of ageGroup, sex, and daysPriorObservation. If FALSE, only the
first value specified for the other factors will be used. Consequently,
order of values matters when requirementInteractions is FALSE.}
}
\value{
A cdm reference
}
\description{
\code{generateTargetDenominatorCohortSet()} creates a set of cohorts that
can be used for the denominator population in analyses of incidence,
using \code{estimateIncidence()}, or prevalence, using \code{estimatePointPrevalence()}
or \code{estimatePeriodPrevalence()}.
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 1000)
cdm <- generateTargetDenominatorCohortSet(
  cdm = cdm,
  name = "denominator",
  targetCohortTable = "target",
  cohortDateRange = as.Date(c("2008-01-01", "2020-01-01"))
)
cdm
}
}
