% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCutTimeForIDRCSet.R
\name{calculateCutTimeForIDRCSet}
\alias{calculateCutTimeForIDRCSet}
\title{calculateCutTimeForIDRCSet}
\usage{
calculateCutTimeForIDRCSet(idrc_set, baseline_time = 24, no_doublings = 4,
  max_val = 80)
}
\arguments{
\item{idrc_set}{IncucyteDRCSet object}

\item{baseline_time}{The timepoint which forms the baseline for calculting number of doublings}

\item{no_doublings}{The number of doublings required}

\item{max_val}{The maximum allowable growth curve value}
}
\value{
IncucyteDRCSet object
}
\description{
Uses the control growth curves in an IncucyteDRCSet to calclate the appropriate cut time for a specific
number of doublings
}
\examples{
pm_file <- system.file(file='extdata/example.PlateMap', package='IncucyteDRC')
test_pm <- importPlatemapXML(pm_file)
data_file <- system.file(file='extdata/example_data.txt', package='IncucyteDRC')
test_data <- importIncucyteData(data_file, metric='pc')

test_list <- splitIncucyteDRCPlateData(test_pm, test_data, group_columns='growthcondition')

print(test_list)

test_idrc_set <- fitGrowthCurvesGrouped(test_list[[2]])
plotIncucyteDRCSet(test_idrc_set, grouped=TRUE)
test_idrc_set <- calculateCutTimeForIDRCSet(test_idrc_set)
plotIncucyteDRCSet(test_idrc_set, grouped=TRUE)
print(test_idrc_set$cut_plot)

}

