% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bilateral.R
\name{priceIndex}
\alias{priceIndex}
\title{Computes a bilateral price index}
\usage{
priceIndex(
  x,
  pvar,
  qvar,
  pervar,
  indexMethod = "laspeyres",
  prodID,
  sample = "matched",
  output = "pop",
  chainMethod = "pop",
  sigma = 1.0001,
  basePeriod = 1,
  biasAdjust = TRUE,
  weights = "average",
  loweYoungBase = 1,
  ...
)
}
\arguments{
\item{x}{A dataframe containing price, quantity, a time period identifier
and a product identifier. It must have column names.}

\item{pvar}{A character string for the name of the price variable}

\item{qvar}{A character string for the name of the quantity variable}

\item{pervar}{A character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{indexMethod}{A character string to select the index number method. Valid index
number methods are dutot, carli, jevons, laspeyres, paasche, fisher, cswd,
harmonic, tornqvist, satovartia, walsh, CES, geomLaspeyres, geomPaasche, tpd,
Geary-Khamis (gk), drobish, palgrave, stuvel, marshalledgeworth.}

\item{prodID}{A character string for the name of the product identifier}

\item{sample}{A character string specifying whether a matched sample
should be used.}

\item{output}{A character string specifying whether a chained (output="chained")
, fixed base (output="fixedbase") or period-on-period (output="pop")
price index numbers should be returned. Default is period-on-period.}

\item{chainMethod}{A character string specifying the method of chain linking
to use if the output option is set to "chained".
Valid options are "pop" for period-on-period, and similarity chain linked
options "plspread" for the Paasche-Laspeyres spread, "asymplinear" for
weighted asymptotically linear, "logquadratic" for the weighted log-quadratic,
and "mixScale" for the mix, scale or absolute dissimilarity measures.
The default is period-on-period. Additional parameters can be passed to the
mixScaleDissimilarity function using \code{...}}

\item{sigma}{The elasticity of substitution for the CES index method.}

\item{basePeriod}{The period to be used as the base when 'fixedbase' output is
chosen. Default is 1 (the first period).}

\item{biasAdjust}{whether to adjust for bias in the coefficients in the bilateral
TPD index. The default is TRUE.}

\item{weights}{the type of weighting for the bilateral TPD index. Options are
"unweighted" to use ordinary least squares, "shares" to use weighted least squares
with expenditure share weights, and "average" to use weighted least squares
with the average of the expenditure shares over the two periods.}

\item{loweYoungBase}{the period used as the base for the lowe or
young type indexes. The default is period 1. This can be a vector of values to
use multiple periods. For example, if the data are monthly and start in January, specifying
1:12 will use the first twelve months as the base.}

\item{...}{this is used to pass additional parameters to the mixScaleDissimilarity
function.}
}
\description{
A function to compute a price index given data on products over time
}
\examples{
# period-on-period Laspeyres index for the CES_sigma_2 dataset
priceIndex(CES_sigma_2, pvar="prices", qvar="quantities", pervar="time",
prodID = "prodID", indexMethod = "laspeyres")

# chained Fisher index
priceIndex(CES_sigma_2, pvar="prices", qvar="quantities", pervar="time",
prodID = "prodID", indexMethod = "fisher", output="chained")

# chained Tornqvist index, with linking periods chosen by the
# weighted log-quadratic dissimilarity measure
priceIndex(CES_sigma_2, pvar="prices", qvar="quantities", pervar="time",
prodID = "prodID", indexMethod = "tornqvist", output="chained",
chainMethod = "logquadratic")
}
