% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingfunctions.R
\name{PermutationCountSummary}
\alias{PermutationCountSummary}
\title{Return the number of significant analytes and the number 
of permutations in which each analyte is significant.
If plot = TRUE, show a box plot of number of significant analytes over permutations, 
overlaid with the number of significant analytes in the original data.}
\usage{
PermutationCountSummary(inputResults, permResults, plot)
}
\arguments{
\item{inputResults}{Data frame with model results (output of ProcessResults())}

\item{permResults}{An object of type PermutationResults (output of PermuteIntLIM())}

\item{plot}{Whether or not to show the boxplot. Default is TRUE.}
}
\value{
A data frame that includes, for each permutation, the number of significant
pairs and the number of unique analytes of each analyte type within those pairs
}
\description{
Return the number of significant analytes and the number 
of permutations in which each analyte is significant.
If plot = TRUE, show a box plot of number of significant analytes over permutations, 
overlaid with the number of significant analytes in the original data.
}
