% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossvalfunctions.R
\name{ProcessResultsAllFolds}
\alias{ProcessResultsAllFolds}
\title{Retrieve significant pairs, based on adjusted p-values, interaction
coefficient percentile, and r-squared values. This is a wrapper for ProcessResults.}
\usage{
ProcessResultsAllFolds(
  inputResults,
  inputData,
  pvalcutoff = 0.05,
  interactionCoeffPercentile = 0.5,
  rsquaredCutoff = 0,
  treecuts = 0
)
}
\arguments{
\item{inputResults}{List of IntLimResults object with model results (output of RunIntLimAllFolds())}

\item{inputData}{List of MultiDataSet objects (output of CreateCrossValFolds()) 
with analyte levels and associated meta-data}

\item{pvalcutoff}{cutoff of FDR-adjusted p-value for filtering (default 0.05)}

\item{interactionCoeffPercentile}{percentile cutoff for interaction coefficient 
(default bottom 10 percent (high negative coefficients) and top 10 percent 
(high positive coefficients))}

\item{rsquaredCutoff}{cutoff for lowest r-squared value}

\item{treecuts}{user-selected number of clusters (of pairs) 
to cut the tree into}
}
\value{
List of IntResults object with model results (now includes correlations)
}
\description{
Retrieve significant pairs, based on adjusted p-values, interaction
coefficient percentile, and r-squared values. This is a wrapper for ProcessResults.
}
