% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InteRD.R
\name{InteRD1}
\alias{InteRD1}
\title{The InteRD1 estimate from reference ensemble}
\usage{
InteRD1(bulk.data,list_marker,cell_type_unique,comb_used,
lambda_option,tol=1e-06)
}
\arguments{
\item{bulk.data}{The `ExpressionSet` object for a target bulk data.}

\item{list_marker}{A list of pre-specified marker genes corresponding to each cell type.}

\item{cell_type_unique}{A list of cell types. It should match the order in list.marker.}

\item{comb_used}{A list of pre-estimated cell type proportions based on different references.}

\item{lambda_option}{A sequence of values for the tuning parameter.}

\item{tol}{A tolerance value for convergence. The default is 1e-06}
}
\value{
A list containing estimated cell type proportions corresponding to each tuning value, named `est`;
and a sequence of goodness-of-fit values corresponding to each tuning value, named `metrics`.
The smaller the better; and a list of weights corresponding to each tuning value, named `weights_list`.
}
\description{
This function provides a reference-based deconvolution by resembling all estimated cell-type proportions based on each reference set.
}
\examples{
##read data
library(InteRD)
readRDSFromWeb<-function(ref) {readRDS(gzcon(url(ref)))}
urlremote<-"https://github.com/chencxxy28/Data/raw/main/data_InteRD/"
pseudo.seger<-readRDSFromWeb(paste0(urlremote,"pseudo.seger.rds"))
comb<-readRDSFromWeb(paste0(urlremote,"comb_seger.rds"))
list_marker<-readRDSFromWeb(paste0(urlremote,"list_markerbaron20.rds"))
lambda_option<-0
cell_type_unique<-c("alpha","beta","delta","gamma")
InteRD1.output<-InteRD1(bulk.data =pseudo.seger,list_marker,
cell_type_unique,comb_used=comb,lambda_option,tol=1e-02)
InteRD1<-InteRD.predict.prop(InteRD.output=InteRD1.output)

}
