% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Functions.R
\name{nullcov}
\alias{nullcov}
\title{nullcov}
\usage{
nullcov(dat, responseVector, methodMultTest, data_type)
}
\arguments{
\item{dat}{Contains the gene expression data matrix for all the genes - can be a matrix or an expression set.}

\item{responseVector}{Vector containing the bio-activity data.}

\item{methodMultTest}{Character string to specify the multiple testing method. Default is the BH-FDR method.}

\item{data_type}{Binary, specifying the type of the parameter dat: 0 - expressionSet, 1 - matrix.}
}
\value{
A data frame, containing the results of the model - same as the output of the fitJM function.
}
\description{
The nullcov function is called while fitting the model when there no covariate is specified in the fitJM function. It returns a data.frame containing the results after fitting the model. The output of this function is also the output of the fitJM function.
}
\details{
Fits the model using gls, calculates the correlation, p-values, adjusted p-values (based on the multiple testing method) and logratio from LRT and returns the required results.
}
\examples{
\dontrun{
nullcov(dat=gene_eset,responseVector=activity,methodMultTest='fdr',data_type=0)
}
}

