% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_power_curve.R
\name{plot_power_curve}
\alias{plot_power_curve}
\title{Plot power curve}
\usage{
plot_power_curve(
  power_data,
  x = NULL,
  group = NULL,
  facets = NULL,
  power_target = 0.8
)
}
\arguments{
\item{power_data}{Data frame of results from power_interaction(). Can accept the raw results if up to 3 parameters were varied during simulation. Any more and data should be filtered first.}

\item{x}{Optional, the x-axis of the plot. Default is the first variable after 'pwr'.}

\item{group}{Optional, grouping variable for the line color. Default is the second variable after 'pwr', if present.}

\item{facets}{Optional, grouping variable for plot facets. Default is the third variable after 'pwr' if present.}

\item{power_target}{The target power. Default is 80\%.}
}
\value{
A ggplot2 object
}
\description{
Plot the output of power_interaction().
}
\examples{
 power_analysis <- power_interaction(n.iter = 10,N = seq(100,300,by=100),
 r.x1.y = 0,r.x2.y = .1,r.x1x2.y = -.2,r.x1.x2 = .3,detailed_results = TRUE)
 plot_power_curve(power_analysis)
}
