% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendToMSF.r
\name{sendToMSF}
\alias{sendToMSF}
\alias{sendToMSF.default}
\alias{sendToMSF.findMAIN}
\title{Exporting spectra to MSFinder.}
\usage{
sendToMSF(x, ...)

\method{sendToMSF}{default}(x, precursormz, precursortype = "[M+H]+",
  outfile = NULL, MSFexe = NULL, ...)

\method{sendToMSF}{findMAIN}(x, rank = 1, ms2spec = NULL, outfile = NULL,
  MSFexe = NULL, ...)
}
\arguments{
\item{x}{A matrix or 'findMAIN' object}

\item{...}{Arguments passed to methods of \code{\link{writeMSF}}.}

\item{precursormz}{m/z of (de)protonated molecule or adduct ion}

\item{precursortype}{adduct type, e.g. "[M+H]+", "[M+Na]+". Accepted values are all adduct ions supported by MSFINDER.}

\item{outfile}{Name of MAT file. If NULL, a temporary file is created in the  per-session temporary directory (see \code{\link{tempdir}}).}

\item{MSFexe}{Full path of MS-FINDER executable. This needs to be set  according to your system. If \code{NULL}, MAT files are written but the program is not opened.}

\item{rank}{Which rank from 'findMAIN' should be exported}

\item{ms2spec}{An (optional) MS2 spectrum to be passed to MSFINDER. If  \code{NULL}, the MS1 spectrum used by 'findMAIN' is used. If dedicated MS2 spectra are available, this option should be used.}
}
\value{
Full path of generated MAT file (invisibly).
}
\description{
Send spectrum to MSFinder.
}
\details{
In the default case 'x' can be a matrix or data frame, where the first two columns are assumed to contain the 'mz' and 'intensity' values, respectively. Further arguments 'precursormz' and 'precursortype' are required in this case. Otherwise 'x' can be of class \code{findMAIN}.
}
\references{
H.Tsugawa et al (2016) Hydrogen rearrangement rules: computational MS/MS fragmentation and structure elucidation using MS-FINDER software. Analytical Chemistry, 88, 7946-7958
}
