% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateMetaboliteSQLiteDB.R
\name{GenerateMetaboliteSQLiteDB}
\alias{GenerateMetaboliteSQLiteDB}
\title{GenerateMetaboliteSQLiteDB.}
\usage{
GenerateMetaboliteSQLiteDB(
  dbfile = "SQLite_APCI.db",
  ionization = c("APCI", "ESI")[1],
  mass_range = c(100, 105),
  ncores = 1,
  silent = TRUE
)
}
\arguments{
\item{dbfile}{Path and file name of the final SQLiteDB or NULL to return the data frame.}

\item{ionization}{Has to be specified to account for different plausibility rules and
elemental composition.}

\item{mass_range}{For testing use default range, otherwise use your measurement range.}

\item{ncores}{Number of cores. Use as many as possible.}

\item{silent}{Set to FALSE to get progress messages.}
}
\value{
Returns the resulting data frame invisible. Will write an SQL_DB if 'dbfile'
   provides a valid path and file name.
}
\description{
\code{GenerateMetaboliteSQLiteDB} will set up a SQLite data base containing
   potential metabolite formulas, #' their masses and isotopic distribution for use with
   \link{InterpretMSSpectrum}.
}
\details{
The process takes a long time for larger masses (>400 Da). Parallel processing
   with 8 cores is highly recommended. Alternatively pre-processed versions can be downloaded
   on request to \email{jan.lisec@bam.de}. To process a 1 Da range (from 900 to 901) for
   ESI does take approximately 5 minutes on 8 cores.
}
\examples{
# this would be relatively fast, but for higher masses it is getting much slower
db <- GenerateMetaboliteSQLiteDB(dbfile = NULL)

}
