% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-IntervalData.R
\docType{class}
\name{IntervalData-class}
\alias{IntervalData-class}
\title{S4 class representing an interval-valued data}
\description{
Each nonempty compact real interval \eqn{K} can be characterised in terms of either
its infimum and supremum or its mid-point and spread as follows,
\deqn{K = [\inf K,\sup K]=[\mathrm{mid}~K \mp \mathrm{spr}~K],}
where \eqn{\inf K \leq \sup K} and \eqn{\mathrm{spr}~K \geq 0.}
}
\section{Slots}{

\describe{
\item{\code{mid}:}{Single numeric value specifying the mid-point of the interval.}
\item{\code{spr}:}{Single numeric value specifying the spread of the interval.}}
}

\examples{
showClass("IntervalData")
showMethods(classes = "IntervalData")
}
\seealso{
Other IntervalData-method: 
\code{\link{IntervalData}},
\code{\link{arithmetic}},
\code{\link{as.IntervalData}()},
\code{\link{distance}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{plot}()},
\code{\link{show}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalData-method}
