% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irescale.R
\name{loadFile}
\alias{loadFile}
\title{Loads a file with latitude, longitude and variable of interest}
\usage{
loadFile(fileName)
}
\arguments{
\item{fileName}{the file's name and path.}
}
\value{
it returns a data frame with two variables \eqn{data} and \eqn{varOfInterest}. The variable \eqn{data} is a 2D list with the latitude and longitude respectly, while the variable \eqn{varOfInterest} is a matrix with all the variables to calculate and rescale Moran's I.
}
\description{
\code{loadFile} loads the input file with the following format:
\itemize{
\item Column 1  represents  the sample Id. It has to be Unique.
\item Column 2,3 Lat/Long respectively.
\item Column 4 and beyond the variables of interest.
}
}
\examples{
fileInput <- system.file("testdata", "chessboard.csv", package="Irescale")
data<-loadFile(fileInput)
}
