% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIWcode.R
\name{mo}
\alias{mo}
\title{Multiple outputation for longitudinal data subject to irregular observation.}
\usage{
mo(noutput, fn, data, weights, singleobs, id, time, keep.first,
  var = TRUE, ...)
}
\arguments{
\item{noutput}{the number of outputations to be used}

\item{fn}{the function to be applied to the outputted datasets. fn should return a vector or scalar; if var=TRUE the second column of fn should be an estimate of standard error.}

\item{data}{the original dataset on which multiple outputation is to be performed}

\item{weights}{the weights to be used in the outputation, i.e. the inverse of the probability that a given observation will be selected in creating an outputted dataset. Ignored if singleobs=TRUE}

\item{singleobs}{logical variable indicating whether a single observation should be retained for each subject}

\item{id}{character string indicating which column of the data identifies subjects}

\item{time}{character string indicating which column of the data contains the time at which the visit occurred}

\item{keep.first}{logical variable indicating whether the first observation should be retained with probability 1. This is useful if the data consists of an observation at baseline followed by follow-up at stochastic time points.}

\item{var}{logical variable indicating whether fn returns variances in addition to point estimates}

\item{...}{other arguments to fn.}
}
\value{
a list containing the multiple outputation estimate of the function fn applied to the data, its standard error, and the relative efficiency of using noutput outputations as opposed to an infinite number
}
\description{
Multiple outputation is a procedure whereby excess observations are repeatedly randomly sampled and discarded. The method was originally developed to handle clustered data where cluster size is informative, for example when studying pups in a litter. In this case, analysis that ignores cluster size results in larger litters being over-represented in a marginal analysis. Multiple outputation circumvents this problem by randomly selecting one observation per cluster. Multiple outputation has been further adapted to handle longitudinal data subject to irregular observation; here the probability of being retained on any given outputation is inversely proportional to the visit intensity. This function creates multiply outputted datasets, analyses each separately, and combines the results to produce a single estimate.
}
\examples{
library(nlme)
data(Phenobarb)
library(survival)
library(geepack)
Phenobarb$id <- as.numeric(Phenobarb$Subject)
Phenobarb$event <- as.numeric(is.finite(Phenobarb$conc))
Phenobarb.conc <- Phenobarb[is.finite(Phenobarb$conc),]
i <- iiw.weights(Surv(time.lag,time,event)~I(conc.lag>0) + conc.lag + cluster(Subject),
id="id",time="time",event="event",data=Phenobarb.conc,invariant="Subject",
lagvars=c("time","conc"),maxfu=NULL,lagfirst=0,first=TRUE)
Phenobarb.conc$weight <- i$iiw.weight
reg <- function(data){
 	return(data.matrix(summary(geeglm(conc ~ time*log(time) ,
 	id=Subject, data=data))$coefficients[,1:2]))
 }

mo(20,reg,Phenobarb.conc,Phenobarb.conc$weight,singleobs=FALSE,id="id",time="time",keep.first=FALSE)
# does not yield valid variance estimates
# once thinned the dataset contains fewer than 30 subjects for most outputations,
# so the sandwich variance estimate from the GEE is too small
}
\references{
\itemize{
\item Hoffman E, Sen P, Weinberg C. Within-cluster resampling. Biometrika 2001; 88:1121-1134
\item Follmann D, Proschan M, Leifer E. Multiple outputation: inference for complex clustered data by averaging analyses from independent data. Biometrics 2003; 59:420-429
\item Pullenayegum EM. Multiple outputation for the analysis of longitudinal data subject to irregular observation. Statistics in Medicine (in press)}.
}
\seealso{
Other mo: \code{\link{outputation}}
}
\concept{mo}
