% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIWcode.R
\name{iiw}
\alias{iiw}
\title{Given a proportional hazards model for visit intensities, compute inverse-intensity weights.}
\usage{
iiw(phfit, data, id, time, first)
}
\arguments{
\item{phfit}{coxph object for the visit process}

\item{data}{The dataset featuring longitudinal data subject to irregular observation for which inverse-intensity weights are desired}

\item{id}{character string indicating which column of the data identifies subjects}

\item{time}{character string indicating which column of the data contains the time at which the visit occurred}

\item{first}{logical variable. If TRUE, the first observation for each individual is assigned an intensity of 1. This is appropriate if the first visit is a baseline visit at which recruitment to the study occurred; in this case the baseline visit is observed with probability 1.}
}
\value{
A vector of inverse-intensity weights for each row of the dataset. The first observation for each subject is assumed to have an intensity of 1.
}
\description{
For a longitudinal dataset subject to irregular observation, use a Cox proportional hazards model for visit intensities to compute inverse intensity weights
}
\examples{
library(nlme)
data(Phenobarb)
library(survival)
library(geepack)
data(Phenobarb)
Phenobarb$event <- 1-as.numeric(is.na(Phenobarb$conc))
data <- lagfn(Phenobarb, lagvars="dose", id="Subject", time="time", lagfirst = 0)
data <- lagfn(data, lagvars="dose.lag", id="Subject", time="time", lagfirst = 0)
data <- lagfn(data, lagvars="dose.lag.lag", id="Subject", time="time", lagfirst = 0)
data$dose.lag[is.na(data$dose.lag)] <- data$dose.lag.lag[is.na(data$dose.lag)]
data$dose.lag[is.na(data$dose.lag)] <- data$dose.lag.lag.lag[is.na(data$dose.lag)]
data <- data[data$event==1,]
data$id <- as.numeric(data$Subject)
data <- data[data$time<16*24,]
data <- lagfn(data, lagvars=c("time","conc"), id="Subject", time="time", lagfirst = NA)
head(data)

mph <- coxph(Surv(time.lag,time,event)~I(conc.lag>0) + conc.lag + cluster(id),data=data)
summary(mph)
data$weight <- iiw(mph,data,"id","time",TRUE)
head(data)
}
\seealso{
Other iiw: 
\code{\link{iiw.weights}()},
\code{\link{iiwgee}()}
}
\concept{iiw}
