% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landscape.R
\name{make_3d_Isingland}
\alias{make_3d_Isingland}
\title{Make a 3D landscape for an Ising network}
\usage{
make_3d_Isingland(thresholds, weiadj, x, y, beta = 1, transform = FALSE)
}
\arguments{
\item{thresholds, weiadj}{The thresholds and the weighted adjacency matrix
of the Ising network. If you have an \code{IsingFit} object estimated using
\code{\link[IsingFit:isingfit]{IsingFit::IsingFit()}}, you can find those two parameters in its components
(\verb{<IsingFit>$thresholds} and \verb{<IsingFit>$weiadj}).}

\item{x, y}{Two vectors specifying the indices or the names of the
nodes for two categories.}

\item{beta}{The \eqn{\beta} value for calculating the Hamiltonian.}

\item{transform}{By default, this function considers the Ising network
to use \code{-1} and \code{1} for two states. Set \code{transform = TRUE} if the Ising
network uses \code{0} and \code{1} for two states, \emph{which is often the case for the
Ising networks estimated using} \code{\link[IsingFit:isingfit]{IsingFit::IsingFit()}}.}
}
\value{
A \verb{3d_Isingland} object that contains the following components:
\itemize{
\item \code{dist_raw},\code{dist} Two tibbles containing the probability
distribution and the potential values for different states.
\item \code{thresholds},\code{weiadj},\code{beta} The parameters supplied to the function.
\item \code{Nvar} The number of variables (nodes) in the Ising network.
}
}
\description{
Similar to \code{\link[=make_2d_Isingland]{make_2d_Isingland()}}, but two categories of nodes can
be specified so the number of active nodes can be calculated
separately.
}
\seealso{
\code{\link[=make_2d_Isingland]{make_2d_Isingland()}} for the algorithm.
}
