% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepdata.R
\name{prepdata}
\alias{prepdata}
\title{Filter the dataset to create an isoscape}
\usage{
prepdata(data, month = 1:12, year, long.min, long.max, lat.min, lat.max,
  split.by = NULL, prop.random = 0, random.level = "station",
  col.isoscape.value = "isoscape.value", col.stationID = "stationID",
  col.lat = "lat", col.long = "long", col.elev = "elev",
  col.month = "month", col.year = "year")
}
\arguments{
\item{data}{A \var{dataframe} containing original isotopic measurements}

\item{month}{A \var{numeric vector} indicating the months to select
from. Should be a vector of round numbers between 1 and 12. The default is 
1:12 selecting all months.}

\item{year}{A \var{numeric vector} indicating the years to select
from. Should be a vector of round numbers. The default is 
to select all years available.}

\item{long.min}{A \var{numeric} indicating the minimum longitude to select
from. Should be a number between -180 and 180. If not provided, -180 will be
considered.}

\item{long.max}{A \var{numeric} indicating the maximal longitude to select
from. Should be a number between -180 and 180. If not provided, 180 will be
considered.}

\item{lat.min}{A \var{numeric} indicating the minimum latitude to select
from. Should be a number between -90 and 90. If not provided, -90 will be
considered.}

\item{lat.max}{A \var{numeric} indicating the maximal latitude to select
from. Should be a number between -90 and 90. If not provided, 90 will be
considered.}

\item{split.by}{A \var{string} indicating whether data should be aggregated 
per location (\code{split.by = NULL}, the default), per location:month 
combination (\code{split.by = "month"}), or per location:year combination 
(\code{split.by = "year"}).}

\item{prop.random}{A \var{numeric} indicating the proportion of observations 
or sampling locations (depending on the argument for \code{random.level})
that will be kept. If \code{prop.random} is greater than 0, then the
function will return a list containing two dataframes: one containing the
selected data, called \code{selected.data}, and one containing the
remaining data, called \code{remaining.data}.}

\item{random.level}{A \var{string} indicating the level at which random draws
can be performed. The two possibilities are \code{"obs"}, which indicates
that observations are randomly drawn taken independently of their location,
or "station" (default), which indicates that observations are randomly
drawn at the level of sampling locations.}

\item{col.isoscape.value}{A \var{string} indicating the column containing the
isotopic measurements}

\item{col.stationID}{A \var{string} indicating the column containing the ID
of each sampling location}

\item{col.lat}{A \var{string} indicating the column containing the latitude
of each sampling location}

\item{col.long}{A \var{string} indicating the column containing the longitude
of each sampling location}

\item{col.elev}{A \var{string} indicating the column containing the elevation
of each sampling location}

\item{col.month}{A \var{string} indicating the column containing the month of
sampling}

\item{col.year}{A \var{string} indicating the column containing the year of
sampling}
}
\value{
This function returns a \var{dataframe} containing the filtered data 
  aggregated by sampling location, or a \var{list}, see above argument 
  \code{prop.random}. For each sampling location the mean and variance sample
  estimates are computed.
}
\description{
This function prepares the available dataset to be used for creating the
isoscape (e.g. \var{GNIPDataDE}) . This function allows the trimming of data
by months, years and location, and for the aggregation of selected data per 
location, location:month combination or location:year combination. The
function can also be used to randomly exclude some observations.
}
\details{
This function aggregates the data as required for the IsoriX workflow. Three 
aggregation schemes are possible. The most simple one, used as default, 
aggregates the data so to obtained a single row per sampling location. 
Datasets prepared in this way can be readily fitted with the function 
\code{\link{isofit}} to build an isoscape. It is also possible to aggregate 
data in a different way in order to build sub-isoscapes representing temporal
variation in isotope composition, or in order to produce isoscapes weighted 
by the amount of precipitation (for isoscapes on precipitation data only). 
The two possible options are to either split the data from each location by 
month or to split them by year. This is set with the \code{split.by} argument
of the function. Datasets prepared in this way should be fitted with the
function \code{\link{isomultifit}}.

The function also allows the user to filter the sampling locations 
based on time (years and/ or months) and space
(locations given in geographic coordinates, i.e. longitude and latitude) to
calculate tailored isoscapes matching e.g. the time of sampling and speeding
up the model fit by cropping/clipping a certain area. The dataframe
produced by this function can be used as input to fit the isoscape (see
\code{\link{isofit}} and  \code{\link{isomultifit}}).
}
\examples{
## Create a processed dataset for Germany
GNIPDataDEagg <- prepdata(data = GNIPDataDE)

head(GNIPDataDEagg)

## Create a processed dataset for Germany per month
GNIPDataDEmonthly <-prepdata(data = GNIPDataDE,
                             split.by = "month")

head(GNIPDataDEmonthly)

## Create a processed dataset for Germany per year
GNIPDataDEyearly <- prepdata(data = GNIPDataDE,
                             split.by = "year")

head(GNIPDataDEyearly)

## Create isoscape-dataset for warm months in germany between 1995 and 1996
GNIPDataDEwarm <- prepdata(data = GNIPDataDE,
                           month = 5:8,
                           year = 1995:1996)

head(GNIPDataDEwarm)


## Create a dataset with 90\% of obs
GNIPDataDE90pct <- prepdata(data = GNIPDataDE,
                            prop.random = 0.9,
                            random.level = "obs")

lapply(GNIPDataDE90pct, head) # show beginning of both datasets

## Create a dataset with half the weather stations
GNIPDataDE50pctStations <- prepdata(data = GNIPDataDE,
                                    prop.random = 0.5,
                                    random.level = "station")

lapply(GNIPDataDE50pctStations, head)


## Create a dataset with half the weather stations split per month
GNIPDataDE50pctStationsMonthly <- prepdata(data = GNIPDataDE,
                                           split.by = "month",
                                           prop.random = 0.5,
                                           random.level = "station")

lapply(GNIPDataDE50pctStationsMonthly, head)

}
\seealso{
\code{\link{IsoriX}} for the complete workflow
}
