% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoscape.R
\name{isomultiscape}
\alias{isomultiscape}
\title{Predicts the average spatial distribution of isotopic values over months,
years...}
\usage{
isomultiscape(raster, isofit, weighting = NULL, verbose = interactive())
}
\arguments{
\item{raster}{The structural raster (\emph{SpatRaster}) such as an elevation
raster created using \link{prepelev}}

\item{isofit}{The fitted isoscape created by \link{isofit}}

\item{weighting}{An optional RasterBrick containing the weights}

\item{verbose}{A \emph{logical} indicating whether information about the
progress of the procedure should be displayed or not while the function is
running. By default verbose is \code{TRUE} if users use an interactive R
session and \code{FALSE} otherwise.}
}
\value{
This function returns a \emph{list} of class \emph{ISOSCAPE}
containing a set of all 8 raster layers mentioned above (all being of
class \emph{SpatRaster}), and the location of the sources as spatial points.
}
\description{
This function is the counterpart of \link{isoscape} for the objects
created with \link{isomultifit}. It creates the isoscapes for each
strata (e.g. month) defined by \code{split_by} during the call to
\link{isomultifit} and the aggregate them. The function can handle
weighting for the aggregation process and can thus be used to predict annual
averages precipitation weighted isoscapes.
}
\examples{

## The examples below will only be run if sufficient time is allowed
## You can change that by typing e.g. options_IsoriX(example_maxtime = XX)
## if you want to allow for examples taking up to ca. XX seconds to run
## (so don't write XX but put a number instead!)

if(getOption_IsoriX("example_maxtime") > 180) {

## We prepare the data and split them by month:

GNIPDataDEmonthly <- prepsources(data = GNIPDataDE,
                                 split_by = "month")

dim(GNIPDataDEmonthly)

## We fit the isoscapes:#' 
GermanMultiFit <- isomultifit(data = GNIPDataDEmonthly,
                              mean_model_fix = list(elev = TRUE, lat.abs = TRUE))

## We build the annual isoscapes by simple averaging (equal weighting):
GermanMultiscape <- isomultiscape(raster = ElevRasterDE,
                                  isofit = GermanMultiFit)

## We build the annual isoscapes with a weighing based on precipitation amount:
GermanMultiscapeWeighted <- isomultiscape(raster = ElevRasterDE,
                                          isofit = GermanMultiFit,
                                          weighting = PrecipBrickDE)

## We plot the mean isoscape of the averaging with equal weighting:
plot(x = GermanMultiscape, which = "mean")

## We plot the mean isoscape of the averaging with precipitation weighting:
plot(x = GermanMultiscapeWeighted, which = "mean")

## We build the isoscapes for a given month (here January):
GermanScapeJan <- isoscape(raster = ElevRasterDE,
                           isofit = GermanMultiFit$multi_fits[["month_1"]])
                         
## We plot the mean isoscape for January:
plot(x = GermanScapeJan, which = "mean")

}
}
\seealso{
\link{isoscape} for details on the function used to compute the isoscapes for each strata
\link{isomultifit} for the function fitting the isoscape

\link{plot.ISOSCAPE} for the function plotting the isoscape model

\link{IsoriX} for the complete work-flow
}
\keyword{models}
\keyword{predict}
\keyword{prediction}
\keyword{regression}
