/*
 * Decompiled with CFR 0.152.
 */
package j4r.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.UIManager;

public class J4RTranslator {
    private static Language currentLanguage;
    private static Map<Language, Map<TextableEnum, String>> strings;

    static {
        Locale locale = Locale.getDefault();
        Language[] languageArray = Language.values();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            if (locale.getLanguage().equals(language.getLocale().getLanguage())) {
                J4RTranslator.setCurrentLanguage(language);
                break;
            }
            J4RTranslator.setCurrentLanguage(Language.English);
            ++n2;
        }
        strings = new HashMap<Language, Map<TextableEnum, String>>();
        Language[] languageArray2 = Language.values();
        n2 = languageArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            Language language = languageArray2[n3];
            strings.put(language, new HashMap());
            ++n3;
        }
    }

    public static void setString(TextableEnum element, String englishText, String frenchText) {
        strings.get((Object)Language.English).put(element, englishText);
        strings.get((Object)Language.French).put(element, frenchText);
    }

    public static String getString(TextableEnum messageID) {
        return J4RTranslator.getTranslation(messageID, J4RTranslator.getCurrentLanguage());
    }

    public static void setCurrentLanguage(Language language) {
        currentLanguage = language;
        UIManager.getDefaults().setDefaultLocale(currentLanguage.getLocale());
        Locale.setDefault(currentLanguage.getLocale());
        if (currentLanguage == Language.English) {
            UIManager.put("OptionPane.noButtonText", "No");
            UIManager.put("OptionPane.yesButtonText", "Yes");
        } else if (currentLanguage == Language.French) {
            UIManager.put("OptionPane.noButtonText", "Non");
            UIManager.put("OptionPane.yesButtonText", "Oui");
        }
    }

    public static Language getCurrentLanguage() {
        return currentLanguage;
    }

    public static String getTranslation(TextableEnum textableEnum, Language language) {
        if (strings.containsKey((Object)language) && strings.get((Object)language).containsKey(textableEnum)) {
            return strings.get((Object)language).get(textableEnum);
        }
        return "";
    }

    public static enum Language {
        English(Locale.ENGLISH, "English", "en"),
        French(Locale.FRANCE, "Fran\u00e7ais", "fr");

        private static Map<String, Language> CodeMap;
        Locale locale;
        String code;
        String longName;

        private Language(Locale locale, String longName, String code) {
            this.locale = locale;
            this.longName = longName;
            this.code = code;
        }

        public String toString() {
            return this.longName;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getCode() {
            return this.code;
        }

        public static Language getLanguage(String code) {
            if (CodeMap == null) {
                CodeMap = new HashMap<String, Language>();
                Language[] languageArray = Language.values();
                int n = languageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Language language = languageArray[n2];
                    CodeMap.put(language.code, language);
                    ++n2;
                }
            }
            return CodeMap.get(code.trim().toLowerCase());
        }
    }

    public static interface TextableEnum {
        public void setText(String var1, String var2);
    }
}

