% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant.R
\name{track_variant}
\alias{track_variant}
\title{Create a VariantTrack for a custom JBrowse 2 view}
\usage{
track_variant(track_data, assembly)
}
\arguments{
\item{track_data}{the URL to the VCF file}

\item{assembly}{the config string generated by \code{assembly}}
}
\value{
a character vector of stringified VariantTrack JSON configuration
}
\description{
Creates the necessary configuration string for an
indexed VCF file so that it can be used
in a JBrowse custom linear genome view.
}
\details{
It is important to note that while only the VCF file is
passed as an argument, \code{tracks_variant} assumes that a VCF
index of the same name is located with the file

For example:

\code{track_alignments("data/variants.vcf")}

Assumes that \code{data/variants.vcf.tbi} also exists.

This is a JBrowse 2 convention, and the default naming output of tabix

For more information on creating an index with tabix, visit
\url{https://www.htslib.org/}
}
\examples{
assembly <- assembly("https://jbrowse.org/genomes/hg19/fasta/hg19.fa.gz", bgzip = TRUE)

track_variant("variants.vcf", assembly)
}
