% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assembly.R
\name{assembly}
\alias{assembly}
\title{Create an assembly for a custom JBrowse view}
\usage{
assembly(assembly_data, bgzip = FALSE, aliases = NULL, refname_aliases = NULL)
}
\arguments{
\item{assembly_data}{the URL to your fasta file}

\item{bgzip}{whether or not your fasta is bgzip compressed}

\item{aliases}{a vector of strings of the aliases for the assembly}

\item{refname_aliases}{the URL to a file containing reference
name aliases. For more info see
\url{https://jbrowse.org/jb2/docs/config_guide#configuring-reference-name-aliasing}}
}
\value{
a character vector of JBrowseR assembly configuration
}
\description{
Creates the necessary configuration string for an
indexed fasta or bgzip fasta so that it can be used
as the assembly in a JBrowse custom linear genome view.
}
\details{
The string returned by \code{assembly} is stringified JSON.
JBrowseR is an interface to JBrowse 2, which receives its
configuration in JSON format. The stringified JSON returned
by \code{assembly} is parsed into a JavaScript object in the
browser, and is used to configure the genome browser.

It is important to note that while only the fasta file is
passed as an argument, \code{assembly} assumes that a fasta
index of the same name is located with the fasta file (as
well as a gzi file in the case of a bgzip fasta).

For example:

\code{assembly("data/hg38.fa")}

Assumes that \code{data/hg38.fa.fai} also exists.

\code{assembly("data/hg38.fa", bgzip = TRUE)}

Assumes that \code{data/hg38.fa.fai} and \code{data/hg38.fa.gzi} both exist.

This is a JBrowse 2 convention, and the default naming output of samtools
and bgzip.

For more information on creating these files, visit
\url{https://jbrowse.org/jb2/docs/quickstart_cli#adding-a-genome-assembly}
}
\examples{
assembly("https://jbrowse.org/genomes/hg19/fasta/hg19.fa.gz", bgzip = TRUE)
}
