\name{ttsAutoML}
\alias{ttsAutoML}

\encoding{latin1}

\title{Train time series by automatic machine learning of \code{h2o} provided by H2O.ai}

\description{
It generates  both the static and recursive time series plots of H2O.ai object generated by package \code{h2o} provided by H2O.ai.
}

\usage{
ttsAutoML(y,x=NULL,train.end,arOrder=2,xregOrder=0,maxSecs=30)
}

\arguments{
  \item{y}{
The time series of target variable, or the dependent variable, with \code{timeSeries} format.
}

  \item{x}{ The time series of input variables, or the independent variables, with \code{timeSeries} format.
}


  \item{train.end}{The end date of training data, must be specificed. The default dates of train.start and test.end are the start and the end of input data; and the test.start is the 1-period next of train.end.

}


\item{arOrder}{The autoregressive order of the target variable, which may be sequentially specifed like arOrder=1:5; or discontinuous lags like arOrder=c(1,3,5); zero is not allowed.

}

\item{xregOrder}{The distributed lag structure of the input variables, which may be sequentially specifed like xregOrder=1:5; or discontinuous lags like xregOrder=c(0,3,5); zero is allowed since contemporaneous correlation is allowed.

}

\item{maxSecs}{The maximal run time specified, in seconds. Default=20.

}



}


\details{

This function calls the h2o.automl function from package \code{h2o} to execute automatic machine learning estimation. When execution finished, it computes two types of time series forecasts: static and recursive. The procedure of h2o.automl automatically generates a lot of time features.
}



\value{

  \item{staticData}{Two-column data with actual target series and the static forecasting series}
  \item{recursiveData}{Two-column data with actual target series and the recursive forecasting series}
  \item{staticF}{The static forecasting series of the period of test data}
  \item{recursiveF}{The recursive forecasting series of the period of test data}
  \item{static.Accuracy}{The accuracy measures of \code{forecast} of static forecasting series}
  \item{recursive.Accuracy}{The accuracy measures of \code{forecast} of recursive forecasting series}
  \item{method}{The train_model_list used in ttsAutoML}
  \item{data}{The data used by arOrder and xregOrder}

}


\author{
Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.

}

\examples{
# Cross-validation takes time, example below is commented.
#library(timeSeries)
data(macrodata)
Y <- macrodata[,"unrate"]
X <- macrodata[,-1]
train.end <- "2008-12-01"

#results<-ttsAutoML(y=Y, x=X, train.end,arOrder=c(2,3), xregOrder=c(1,2),maxSecs=300)
#head(results$data)
#results$static.Accuracy
#results$recursive.Accuracy

}

