/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.editor.FindReplaceDialog;
import org.rosuda.JGR.rhelp.SearchEngine;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.IconButton;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.TextFinder;
import org.rosuda.JGR.util.DocumentRenderer;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class JGRHelp
extends TJFrame
implements ActionListener,
KeyListener,
MouseListener {
    public static JGRHelp current = null;
    private final String keyWord;
    private final JPanel topPanel = new JPanel();
    private final JTabbedPane tabArea = new JTabbedPane();
    private HelpArea helpArea;
    private final JTextField inputKeyWord = new JTextField();
    private final JButton search = new JButton("Search");
    public JLabel link = new JLabel(" ");
    private final JPanel options = new JPanel(new FlowLayout(1));
    private final JCheckBox exactMatch = new JCheckBox("Exact Match", true);
    private final JCheckBox searchDesc = new JCheckBox("Help Page Titles", true);
    private final JCheckBox searchKeyWords = new JCheckBox("Keywords", false);
    private final JCheckBox searchAliases = new JCheckBox("Object Names", false);
    private IconButton back;
    private IconButton home;
    private IconButton forward;
    private SearchEngine searchRHelp;
    private final TextFinder textFinder = new TextFinder();
    private static String index;
    public static String RHELPLOCATION;

    public JGRHelp() {
        this(null);
    }

    public JGRHelp(String string) {
        super("Help", false, 16);
        this.keyWord = null;
        while (!JGR.STARTED) {
        }
        String[] stringArray = new String[]{"+", "File", "@PPrint", "print", "+", "Edit", "@CCopy", "copy", "-", "@RRun selection", "runselection", "@FFind", "search", "@GFind Next", "searchnext", "~Window", "~About", "0"};
        EzMenuSwing.getEzMenu((JFrame)((Object)this), (ActionListener)this, (String[])stringArray);
        if (System.getProperty("os.name").startsWith("Windows")) {
            RHELPLOCATION = RController.getRHome();
            index = "file:/" + RHELPLOCATION.replace('\\', '/') + "/doc/html/packages.html";
        } else {
            RHELPLOCATION = JGR.R.eval("tempdir()").asString() + "/.R";
            index = "file://" + RHELPLOCATION.replace('\\', '/') + "/doc/html/packages.html";
        }
        this.searchRHelp = new SearchEngine();
        this.searchRHelp.setRHelp(this);
        this.search.setActionCommand("searchHelp");
        this.search.addActionListener(this);
        this.getRootPane().setDefaultButton(this.search);
        FontTracker.current.add(this.inputKeyWord);
        this.inputKeyWord.setMinimumSize(new Dimension(150, 25));
        this.inputKeyWord.setPreferredSize(new Dimension(300, 25));
        this.inputKeyWord.setMaximumSize(new Dimension(350, 25));
        this.inputKeyWord.setEditable(true);
        this.options.add(this.exactMatch);
        this.options.add(this.searchDesc);
        this.options.add(this.searchKeyWords);
        this.options.add(this.searchAliases);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.inputKeyWord);
        jPanel.add(this.search);
        jPanel.add(new Spacer(30));
        this.back = new IconButton("/icons/back.png", "Back", this, "back");
        jPanel.add(this.back);
        this.home = new IconButton("/icons/home.png", "Home", this, "home");
        jPanel.add(this.home);
        this.forward = new IconButton("/icons/forward.png", "Forward", this, "forward");
        jPanel.add(this.forward);
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.topPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.topPanel.add((Component)this.options, gridBagConstraints);
        this.back.setEnabled(false);
        this.forward.setEnabled(false);
        this.link.setPreferredSize(new Dimension(200, 20));
        this.helpArea = new HelpArea(this.tabArea, this, null);
        this.helpArea.addKeyListener(this);
        this.tabArea.addTab(this.keyWord == null ? "packages" : this.keyWord, new CloseIcon(this.getClass().getResource("/icons/close.png")), this.helpArea);
        this.tabArea.addMouseListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)this.tabArea, "Center");
        this.getContentPane().add((Component)this.link, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JGRHelp.this.exit();
            }
        });
        this.setMinimumSize(new Dimension(570, 600));
        this.setSize(new Dimension(600, Common.screenRes.height < 800 ? Common.screenRes.height - 50 : 700));
        this.setLocation(Common.screenRes.width - this.getSize().width - 50, 10);
        super.show();
        this.inputKeyWord.requestFocus();
        current = this;
    }

    public void print() {
        DocumentRenderer documentRenderer = new DocumentRenderer();
        documentRenderer.print(((HelpArea)this.tabArea.getSelectedComponent()).helpPane);
    }

    private void back() {
        ((HelpArea)this.tabArea.getSelectedComponent()).back();
    }

    private void home() {
        ((HelpArea)this.tabArea.getSelectedComponent()).goTo(index, true);
    }

    private void forward() {
        ((HelpArea)this.tabArea.getSelectedComponent()).forward();
    }

    private void exit() {
        current = null;
        this.finalize();
        this.dispose();
    }

    public void search() {
        String string = this.inputKeyWord.getText().trim();
        this.search(string);
    }

    public void search(String string, boolean bl) {
        this.exactMatch.setSelected(bl);
        if (!bl) {
            this.searchDesc.setSelected(true);
            this.searchKeyWords.setSelected(true);
            this.searchAliases.setSelected(true);
        }
        this.search(string);
    }

    public void search(String string) {
        if (string != null && !string.equals("")) {
            try {
                if (((HelpArea)this.tabArea.getComponentAt((int)0)).helpPane.getText().indexOf("No matches for") >= 0) {
                    this.tabArea.remove(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.tabArea.getTabCount() == JGRPrefs.maxHelpTabs) {
                this.tabArea.remove(JGRPrefs.maxHelpTabs - 1);
            }
            this.tabArea.add((Component)new HelpArea(this.tabArea, this, string), 0);
            this.tabArea.setSelectedIndex(0);
            this.tabArea.setIconAt(0, new CloseIcon(this.getClass().getResource("/icons/close.png")));
            this.tabArea.setTitleAt(0, string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "back") {
            this.back();
        } else if (string == "copy") {
            ((HelpArea)this.tabArea.getSelectedComponent()).helpPane.copy();
        } else if (string == "exit") {
            this.exit();
        } else if (string == "forward") {
            this.forward();
        } else if (string == "home") {
            try {
                this.home();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string == "print") {
            this.print();
        } else if (string == "runselection") {
            try {
                String string2 = ((HelpArea)this.tabArea.getSelectedComponent()).helpPane.getSelectedText().trim();
                if (string2.length() > 0) {
                    JGR.MAINRCONSOLE.execute(string2.trim(), true);
                }
            }
            catch (Exception exception) {}
        } else if (string == "selAll") {
            ((HelpArea)this.tabArea.getSelectedComponent()).helpPane.selectAll();
        } else if (string == "searchHelp") {
            this.search();
        } else if (string == "search") {
            FindReplaceDialog.findExt((Frame)((Object)this), ((HelpArea)this.tabArea.getSelectedComponent()).helpPane);
        } else if (string == "searchnext") {
            FindReplaceDialog.findNextExt((Frame)((Object)this), ((HelpArea)this.tabArea.getSelectedComponent()).helpPane);
        } else if (string == "tab_close") {
            this.tabArea.remove(this.tabArea.getSelectedIndex());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (System.getProperty("os.name").indexOf("Mac") == -1) {
            this.getRootPane().setDefaultButton(this.search);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown() && System.getProperty("os.name").indexOf("Mac") == -1) {
            try {
                if (((JTextComponent)keyEvent.getComponent()).getSelectedText().trim().length() > 0) {
                    this.getRootPane().setDefaultButton(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        String string;
        if ((keyEvent.isMetaDown() || keyEvent.isControlDown()) && keyEvent.getKeyCode() == 10 && (string = ((JTextComponent)keyEvent.getComponent()).getSelectedText().trim()).length() > 0) {
            JGR.MAINRCONSOLE.execute(string, true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.tabArea.getUI().tabForCoordinate(this.tabArea, mouseEvent.getX(), mouseEvent.getY());
        if (n < 0) {
            return;
        }
        Rectangle rectangle = ((CloseIcon)this.tabArea.getIconAt(n)).getBounds();
        if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.tabArea.remove(n);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    class Spacer
    extends JPanel {
        public Spacer(int n) {
            this.setMinimumSize(new Dimension(n, 0));
            this.setMaximumSize(new Dimension(n, 0));
            this.setPreferredSize(new Dimension(n, 0));
        }
    }

    class CloseIcon
    extends ImageIcon {
        private int x;
        private int y;
        private int width;
        private int height;

        public CloseIcon(URL uRL) {
            super(uRL);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.x = n;
            this.y = n2;
            this.width = this.getIconWidth();
            this.height = this.getIconHeight();
            super.paintIcon(component, graphics, n, n2);
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
    }

    public class HelpArea
    extends JScrollPane {
        public JEditorPane helpPane = new JEditorPane();
        private JGRHelp rhelp;
        private String keyword;
        private final Vector history = new Vector();
        private int currentURLIndex = -1;
        private JTabbedPane tabArea = null;

        public HelpArea(JTabbedPane jTabbedPane, JGRHelp jGRHelp2, String string) {
            this.rhelp = jGRHelp2;
            this.keyword = string;
            this.tabArea = jTabbedPane;
            FontTracker.current.add(this.helpPane);
            this.getViewport().add(this.helpPane);
            this.setVerticalScrollBarPolicy(22);
            this.helpPane.setEditable(false);
            this.helpPane.setContentType("text/html");
            this.helpPane.addKeyListener(jGRHelp2);
            this.helpPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                        if (((HelpArea)HelpArea.this).JGRHelp.this.link != null) {
                            ((HelpArea)HelpArea.this).JGRHelp.this.link.setText(hyperlinkEvent.getURL().toString());
                        }
                    } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                        if (((HelpArea)HelpArea.this).JGRHelp.this.link != null) {
                            ((HelpArea)HelpArea.this).JGRHelp.this.link.setText(" ");
                        }
                    } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        HelpArea.this.goTo(hyperlinkEvent.getURL(), true);
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    HelpArea.this.setButtons();
                }
            });
            if (string == null) {
                this.goTo(index);
            } else {
                this.search();
            }
        }

        private void setButtons() {
            JGRHelp.this.back.setEnabled(this.currentURLIndex > 0);
            JGRHelp.this.forward.setEnabled(this.currentURLIndex + 1 < this.history.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void updatePage(boolean bl) {
            block22: {
                URL uRL;
                block21: {
                    this.rhelp.setWorking(true);
                    this.rhelp.back.setEnabled(this.currentURLIndex > 0);
                    this.rhelp.forward.setEnabled(this.currentURLIndex + 1 < this.history.size());
                    uRL = (URL)this.history.get(this.currentURLIndex);
                    this.helpPane.setPage(uRL);
                    Object var6_3 = null;
                    if (!bl) break block21;
                    try {
                        String string = uRL.toString().substring(uRL.toString().lastIndexOf("/") + 1);
                        string = string.substring(0, string.lastIndexOf(46));
                        int n = this.tabArea.getSelectedIndex();
                        if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("file")) {
                            this.tabArea.setTitleAt(n, string);
                        } else {
                            int n2 = uRL.toString().indexOf("html");
                            string = uRL.toString().substring(0, n2 - 1);
                            string = string.substring(string.lastIndexOf("/") + 1);
                            if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("file")) {
                                this.tabArea.setTitleAt(n, string);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.rhelp.setWorking(false);
                {
                    break block22;
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        try {
                            this.history.remove(this.currentURLIndex);
                            --this.currentURLIndex;
                            this.rhelp.back.setEnabled(this.currentURLIndex > 0);
                            this.rhelp.forward.setEnabled(this.currentURLIndex + 1 < this.history.size());
                            uRL = (URL)this.history.get(this.currentURLIndex);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            JOptionPane.showMessageDialog(this, iOException.getMessage(), "URL Error", 0);
                        }
                        Object var6_4 = null;
                        if (bl) {
                            try {
                                String string = uRL.toString().substring(uRL.toString().lastIndexOf("/") + 1);
                                string = string.substring(0, string.lastIndexOf(46));
                                int n = this.tabArea.getSelectedIndex();
                                if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("file")) {
                                    this.tabArea.setTitleAt(n, string);
                                } else {
                                    int n3 = uRL.toString().indexOf("html");
                                    string = uRL.toString().substring(0, n3 - 1);
                                    string = string.substring(string.lastIndexOf("/") + 1);
                                    if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("file")) {
                                        this.tabArea.setTitleAt(n, string);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.rhelp.setWorking(false);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (bl) {
                        try {
                            String string = uRL.toString().substring(uRL.toString().lastIndexOf("/") + 1);
                            string = string.substring(0, string.lastIndexOf(46));
                            int n = this.tabArea.getSelectedIndex();
                            if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("file")) {
                                this.tabArea.setTitleAt(n, string);
                            } else {
                                int n4 = uRL.toString().indexOf("html");
                                string = uRL.toString().substring(0, n4 - 1);
                                string = string.substring(string.lastIndexOf("/") + 1);
                                if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("file")) {
                                    this.tabArea.setTitleAt(n, string);
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.rhelp.setWorking(false);
                    throw throwable;
                }
            }
        }

        private void back() {
            --this.currentURLIndex;
            this.updatePage(true);
        }

        private void forward() {
            ++this.currentURLIndex;
            this.updatePage(true);
        }

        public void goTo(URL uRL) {
            this.goTo(uRL, false);
        }

        public void goTo(URL uRL, boolean bl) {
            if (uRL != null) {
                ++this.currentURLIndex;
                this.history.setSize(this.currentURLIndex);
                this.history.add(uRL);
                this.updatePage(bl);
            }
        }

        public void goTo(String string) {
            this.goTo(string, false);
        }

        public void goTo(String string, boolean bl) {
            URL uRL = null;
            try {
                uRL = new URL(string);
                this.goTo(uRL, bl);
            }
            catch (MalformedURLException malformedURLException) {
                new ErrorMsg(malformedURLException);
                JOptionPane.showMessageDialog(null, malformedURLException.getMessage(), "URL Error", 0);
                return;
            }
        }

        public void search() {
            if (this.keyword != null && !this.keyword.equals("") && this.rhelp.searchRHelp != null) {
                this.goTo(this.rhelp.searchRHelp.search(this.keyword, this.rhelp.exactMatch.isSelected(), this.rhelp.searchDesc.isSelected(), this.rhelp.searchKeyWords.isSelected(), this.rhelp.searchAliases.isSelected()));
            }
        }
    }
}

