/*
 * Decompiled with CFR 0.152.
 */
package jedit.syntax;

import javax.swing.text.Segment;
import jedit.syntax.KeywordMap;
import jedit.syntax.TokenMarker;

public class EiffelTokenMarker
extends TokenMarker {
    private static KeywordMap eiffelKeywords;
    private KeywordMap keywords = EiffelTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block19: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '%') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                backslash = false;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block19;
                            break;
                        }
                        case '-': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block19;
                            switch (array[i1]) {
                                case '-': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(length - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block19;
                                }
                            }
                            continue block19;
                        }
                        default: {
                            backslash = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block19;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block19;
                }
                case 1: 
                case 2: {
                    throw new RuntimeException("Wrong eiffel parser state");
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block19;
                    }
                    if (c != '\"') continue block19;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block19;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block19;
                    }
                    if (c != '\'') continue block19;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block19;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (eiffelKeywords == null) {
            eiffelKeywords = new KeywordMap(true);
            eiffelKeywords.add("alias", (byte)6);
            eiffelKeywords.add("all", (byte)6);
            eiffelKeywords.add("and", (byte)6);
            eiffelKeywords.add("as", (byte)6);
            eiffelKeywords.add("check", (byte)6);
            eiffelKeywords.add("class", (byte)6);
            eiffelKeywords.add("creation", (byte)6);
            eiffelKeywords.add("debug", (byte)6);
            eiffelKeywords.add("deferred", (byte)6);
            eiffelKeywords.add("do", (byte)6);
            eiffelKeywords.add("else", (byte)6);
            eiffelKeywords.add("elseif", (byte)6);
            eiffelKeywords.add("end", (byte)6);
            eiffelKeywords.add("ensure", (byte)6);
            eiffelKeywords.add("expanded", (byte)6);
            eiffelKeywords.add("export", (byte)6);
            eiffelKeywords.add("external", (byte)6);
            eiffelKeywords.add("feature", (byte)6);
            eiffelKeywords.add("from", (byte)6);
            eiffelKeywords.add("frozen", (byte)6);
            eiffelKeywords.add("if", (byte)6);
            eiffelKeywords.add("implies", (byte)6);
            eiffelKeywords.add("indexing", (byte)6);
            eiffelKeywords.add("infix", (byte)6);
            eiffelKeywords.add("inherit", (byte)6);
            eiffelKeywords.add("inspect", (byte)6);
            eiffelKeywords.add("invariant", (byte)6);
            eiffelKeywords.add("is", (byte)6);
            eiffelKeywords.add("like", (byte)6);
            eiffelKeywords.add("local", (byte)6);
            eiffelKeywords.add("loop", (byte)6);
            eiffelKeywords.add("not", (byte)6);
            eiffelKeywords.add("obsolete", (byte)6);
            eiffelKeywords.add("old", (byte)6);
            eiffelKeywords.add("once", (byte)6);
            eiffelKeywords.add("or", (byte)6);
            eiffelKeywords.add("prefix", (byte)6);
            eiffelKeywords.add("redefine", (byte)6);
            eiffelKeywords.add("rename", (byte)6);
            eiffelKeywords.add("require", (byte)6);
            eiffelKeywords.add("rescue", (byte)6);
            eiffelKeywords.add("retry", (byte)6);
            eiffelKeywords.add("select", (byte)6);
            eiffelKeywords.add("separate", (byte)6);
            eiffelKeywords.add("then", (byte)6);
            eiffelKeywords.add("undefine", (byte)6);
            eiffelKeywords.add("until", (byte)6);
            eiffelKeywords.add("variant", (byte)6);
            eiffelKeywords.add("when", (byte)6);
            eiffelKeywords.add("xor", (byte)6);
            eiffelKeywords.add("current", (byte)4);
            eiffelKeywords.add("false", (byte)4);
            eiffelKeywords.add("precursor", (byte)4);
            eiffelKeywords.add("result", (byte)4);
            eiffelKeywords.add("strip", (byte)4);
            eiffelKeywords.add("true", (byte)4);
            eiffelKeywords.add("unique", (byte)4);
            eiffelKeywords.add("void", (byte)4);
        }
        return eiffelKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        boolean klassname = false;
        int len = i - this.lastKeyword;
        int id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id == 0) {
            klassname = true;
            for (int at = this.lastKeyword; at < this.lastKeyword + len; ++at) {
                char ch = line.array[at];
                if (ch == '_' || Character.isUpperCase(ch)) continue;
                klassname = false;
                break;
            }
            if (klassname) {
                id = 8;
            }
        }
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, (byte)id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

