% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jous.R
\name{jous}
\alias{jous}
\title{Jittering with Over/Under Sampling}
\usage{
jous(X, y, class_func, pred_func, type = "under", delta = 10, nu = 1,
  X_pred = NULL, keep_models = F)
}
\arguments{
\item{X}{A matrix of continuous predictors.}

\item{y}{A vector of responses with entries in \code{c(-1, 1)}.}

\item{class_func}{Function to perform classification.  This function must be
exactly of the form \code{class_func(X, y)} where X is a matrix and y is a
vector with entries in \code{c(-1, 1)}, and it must return an object on which
\code{pred_func} can create predictions.  See examples.}

\item{pred_func}{Function to create predictions.  This function must be
exactly of the form \code{pred_func(fit_obj, X)} where \code{fit_obj}
is an object returned by class_func and X is a matrix of new data
values, and it must return a vector with entries in \code{c(-1, 1)}.
See examples.}

\item{type}{Type of sampling: "over" for oversampling,  or "under" for
undersampling.}

\item{delta}{An integer (greater than 3) to control the number of quantiles to
estimate:}

\item{nu}{The amount of noise to apply to predictors when oversampling data.
The noise level is controlled by \code{nu * sd(X[,j])} for each
predictor - the default of \code{nu = 1} works well.  Such "jittering"
of the predictors is essential when applying \code{jous} to boosting
type methods.}

\item{X_pred}{A matrix of predictors for which to form probability estimates.}

\item{keep_models}{Whether to store all of the models used to create
the probability estimates.  If \code{type=FALSE}, the user will need
to re-run \code{jous} when creating probability estimates for test data.}
}
\value{
Returns an object of class JOUS containing information about the
parameters used in the \code{jous} function call, as well as the following
additional components:
\item{q}{The vector of target quantiles estimated by \code{jous}.  Note that
the estimated probabilities will be located at the midpoints of the values in
\code{q}.}
\item{phat_train}{The in-sample probability estimates \eqn{p(y=1|x)}.}
\item{phat_test}{Probability estimates for the optional test data in \code{X_test}}
\item{models}{If \code{keep_models=TRUE}, a list of models fitted to
the resampled data sets.}
}
\description{
Perform probability estimation using jittering with over or undersampling.
}
\note{
The \code{jous} function runs the classifier \code{class_func} a total
of \code{delta} times on the data, which can be computationally expensive.
Also,\code{jous} cannot yet be applied to categorical predictors - in the
oversampling case, it is not clear how to "jitter" a categorical variable.
}
\examples{
\dontrun{
# Generate data from Friedman model #
set.seed(111)
dat = friedman_data(n = 500, d = 10, gamma = 0.5)
train_index = sample(1:500, 400)

# Apply jous to adaBoost classifier
class_func = function(X, y) adaBoost(X, y, tree_depth = 2, n_rounds = 100)
pred_func = function(fit_obj, X_test) predict(fit_obj, X_test)

jous_fit = jous(dat$X[train_index,], dat$y[train_index], class_func,
                pred_func, type="under", delta=10, keep_models=TRUE)
# get probability
phat_jous = predict(jous_fit, dat$X[-train_index, ], type="prob")

# compare with probability from adaBoost
ada = adaBoost(dat$X[train_index,], dat$y[train_index], tree_depth = 2,
               n_rounds = 100)
phat_ada = predict(ada, dat$X[train_index,], type="prob")

mean((phat_jous - dat$p[-train_index])^2)
mean((phat_ada - dat$p[-train_index])^2)
}

}
\references{
Mease, D., Wyner, A. and Buja, A. (2007). Costweighted
boosting with jittering and over/under-sampling:
JOUS-boost. J. Machine Learning Research 8 409-439.
}

