% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cor2cov}
\alias{cor2cov}
\title{Convert a correlation matrix and standard deviations to a covariance matrix}
\usage{
cor2cov(V, sigma)
}
\arguments{
\item{V}{an n x n correlation matrix.  Should be numeric, square, and symmetric.}

\item{sigma}{an n length vector of the standard deviations. The length of the
vector must match the number of columns in the correlation matrix.}
}
\value{
an n x n covariance matrix
}
\description{
This is a simple function designed to convert a correlation matrix
(standardized covariance matrix) back to a covariance matrix.
It is the opposite of \code{cov2cor}.
}
\examples{
# using a built in dataset
cor2cov(cor(longley), sapply(longley, sd))

# should match the above covariance matarix
cov(longley)
all.equal(cov(longley), cor2cov(cor(longley), sapply(longley, sd)))
}
\seealso{
\code{\link{cov2cor}}
}

