% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{corplot}
\alias{corplot}
\title{Heatmap of a Correlation Matrix}
\usage{
corplot(x, coverage, pvalues, plot = c("cor", "p", "coverage"),
  digits = 2, order = c("cluster", "asis"), ...,
  control.grobs = list())
}
\arguments{
\item{x}{A correlation matrix or some other square symmetric matrix.}

\item{coverage}{An (optional) matrix with the same dimensions as
\code{x} giving the proportion of data present.  Particularly
useful when the correlation matrix is a pairwise present.}

\item{pvalues}{An (optional) matrix with the same dimensions as
\code{x} giving the p values for each correlation. To show, use
\code{plot = "p"}.}

\item{plot}{A character string indicating what to show on top of the heatmap. Can be
\sQuote{coverage}, in which case bubble points show coverage;
\sQuote{p}, in which case p values are shown, or
\sQuote{cor}, in which case correlations are shown.
Only has an effect if a coverage (or pvalue) matrix is passed
also. Defaults to \code{cor}.}

\item{digits}{The number of digits to round to when printing the
correlations on the heatmap. Text is suppressed when a coverage
matrix is passed and \code{points = TRUE}.}

\item{order}{A character string indicating how to order the resulting
plot. Defaults to \sQuote{cluster} which uses hierarchical clustering
to sensibly order the variables. The other option is \sQuote{asis}
in which case the matrix is plotted in the order it is passed.}

\item{\dots}{Additional arguments currently only passed to
\code{hclust} and \code{corOK}.}

\item{control.grobs}{A list of additional \code{quote()}d
options to customize the \code{ggplot2} output.}
}
\value{
Primarily called for the side effect of creating a plot.
  However, the \code{ggplot2} plot object is returned,
  so it can be saved, replotted, edited, etc.
}
\description{
This function creates a heatmap of a correlation matrix using \pkg{ggplot2}.
}
\details{
The actual plot is created using \code{ggplot2} and \code{geom_tile}.
In addition to creating the plot, the variables are ordered based on a
hierarchical clustering of the correlation matrix.  Specifically, \code{1 - x}
is used as the distance matrix. If coverage is passed, will also add a bubble
plot with the area proportional to the proportion of data present for any
given cell.  Defaults for \code{ggplot2} are set, but it is possible to use a
named list of quote()d ggplot calls to override all defaults. This is not
expected for typical use.  Particularly main, points, and text as these rely
on internal variable names; however, labels, the gradient color, and area
scaling can be adjusted more safely.
}
\examples{
# example plotting the correlation matrix from the
# mtcars dataset
corplot(cor(mtcars))

dat <- as.matrix(iris[, 1:4])

# randomly set 25\% of the data to missing
set.seed(10)
dat[sample(length(dat), length(dat) * .25)] <- NA

# create a summary of the data (including coverage matrix)
sdat <- SEMSummary(~ ., data = dat)
# using the plot method for SEMSummary (which basically just calls corplot)
plot(sdat)

## getting p values instaed of coverage
# plot(sdat, plot = "p")

## showing correlations instead of coverage
# plot(sdat, plot = "cor")

# use the control.grobs argument to adjust the coverage scaling
# to go from 0 to 1 rather than the range of coverage
corplot(x = sdat$sSigma, coverage = sdat$coverage,
  control.grobs = list(area = quote(scale_size_area(limits = c(0, 1))))
)

# also works with plot() on a SEMSummary
plot(x = sdat, control.grobs = list(area = quote(scale_size_area(limits = c(0, 1)))))

rm(dat, sdat)
}
\keyword{hplot}
