#' Multilevel Daily Data Example
#'
#' A data frame drawn from a daily diary study, conducted at
#' Monash University in 2017 where young adults old completed measures
#' up to three times per day (morning, afternoon, and evening) for about
#' 12 days.  Thus each participant contributed about 36 observations to
#' the dataset. To protect participant confidentiality and anonymity, the
#' data used here were simulated from the original data, but in such a way
#' as to preserve the relations among variables and most features of the
#' raw data.
#'
#' @format A data frame containing 19 variables.
#' \describe{
#'   \item{UserID}{A unique identifier for each individual}
#'   \item{SurveyDay}{The date each observation occured on}
#'   \item{SurveyInteger}{The survey coded as an integer (1 = morning, 2 = afternoon, 3 = evening)}
#'   \item{SurveyStartTimec11}{Survey start time, centered at time since 11am}
#'   \item{Female}{A 0 or 1 variable, where 1 = female and 0 = male}
#'   \item{Age}{Participant age in years, top coded at 25}
#'   \item{BornAUS}{A 0 or 1 variable where 1 = born in Australia and 0 = born outside of Australia}
#'   \item{SES_1}{Participants subjective SES, bottom coded at 4 and top coded at 8}
#'   \item{EDU}{Participants level of education (1 = university graduate or higher, 0 = less than university graduate}
#'   \item{SOLs}{Self-reported sleep onset latency in minutes, morning survey only}
#'   \item{WASONs}{Self-reported number of wakenings after sleep onset, top coded at 4, morning survey only}
#'   \item{STRESS}{Overall stress ratings on a 0--10 scale, repeated 3x daily}
#'   \item{SUPPORT}{Overall social support ratings on a 0--10 scale, repeated 3x daily}
#'   \item{PosAff}{Positive affect ratings on a 1--5 scale, repeated 3x daily}
#'   \item{NegAff}{Negative affect ratings on a 1--5 scale, repeated 3x daily}
#'   \item{COPEPrb}{Problem focused coping on a 1--4 scale, repeated 1x daily at the evening survey}
#'   \item{COPEPrc}{Emotional processing coping on a 1--4 scale, repeated 1x daily at the evening survey}
#'   \item{COPEExp}{Emotional exprsesion coping on a 1--4 scale, repeated 1x daily at the evening survey}
#'   \item{COPEDis}{Mental disengagement coping on a 1--4 scale, repeated 1x daily at the evening survey}
#' }
"aces_daily"
