/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.GUI;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Databases.DatabaseAssignEvent;
import org.omegahat.Environment.Databases.DatabaseAttachEvent;
import org.omegahat.Environment.Databases.DatabaseDetachEvent;
import org.omegahat.Environment.Databases.DatabaseListener;
import org.omegahat.Environment.Databases.DatabaseNotifier;
import org.omegahat.Environment.Databases.DatabaseRemoveEvent;
import org.omegahat.Environment.GUI.BasicDatabaseRenderer;
import org.omegahat.Environment.GUI.EvaluatorJPanel;
import org.omegahat.Environment.Interpreter.Evaluator;

public class DatabaseViewer
extends EvaluatorJPanel
implements DatabaseListener {
    protected ListCellRenderer renderer;
    protected Database database = null;
    protected JList displayList = null;

    public DatabaseViewer(Database database) {
        this.database(database);
        this.make();
    }

    public DatabaseViewer(Database database, Evaluator evaluator) {
        super(evaluator);
        this.database(database);
        this.make();
    }

    public void assignPerformed(DatabaseAssignEvent databaseAssignEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.displayList.getModel();
        if (!defaultListModel.contains(databaseAssignEvent.name())) {
            defaultListModel.addElement(databaseAssignEvent.name());
        } else {
            this.displayList.repaint();
        }
    }

    public void attachPerformed(DatabaseAttachEvent databaseAttachEvent) {
    }

    public Database database() {
        return this.database;
    }

    public Database database(Database database) {
        this.database = database;
        if (this.database instanceof DatabaseNotifier) {
            ((DatabaseNotifier)this.database).addListener(-1, this);
        }
        return this.database();
    }

    public ListCellRenderer defaultRenderer() {
        return new BasicDatabaseRenderer(this.database());
    }

    public void detachPerformed(DatabaseDetachEvent databaseDetachEvent) {
        this.getParent().remove(this);
    }

    public boolean make() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        String[] stringArray = this.database().objects();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            defaultListModel.addElement(stringArray[n2]);
            ++n2;
        }
        if (this.displayList == null) {
            JScrollPane jScrollPane = new JScrollPane();
            this.add("Center", jScrollPane);
            this.displayList = new JList(defaultListModel);
            jScrollPane.setViewportView(this.displayList);
            ListCellRenderer listCellRenderer = this.renderer();
            if (listCellRenderer == null) {
                listCellRenderer = this.defaultRenderer();
            }
            this.displayList.setCellRenderer(listCellRenderer);
        } else {
            this.displayList.setListData(stringArray);
        }
        return true;
    }

    public void removePerformed(DatabaseRemoveEvent databaseRemoveEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.displayList.getModel();
        defaultListModel.removeElement(databaseRemoveEvent.name());
    }

    public ListCellRenderer renderer() {
        return this.renderer;
    }

    public ListCellRenderer renderer(ListCellRenderer listCellRenderer) {
        this.renderer = listCellRenderer;
        if (this.displayList != null) {
            this.displayList.setCellRenderer(this.renderer());
        }
        return this.renderer();
    }
}

