/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.DefaultHelpModel;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelp;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.UnsupportedOperationException;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class DefaultHelpBroker
implements HelpBroker,
KeyListener {
    protected HelpSet helpset = null;
    protected JFrame frame = null;
    protected JHelp jhelp = null;
    protected Locale locale = null;
    protected Font font = null;
    private transient Thread currGUIInitThread;
    private static int HELP_WIDTH = 645;
    private static int HELP_HEIGHT = 495;
    protected ActionListener displayHelpFromFocus;
    protected ActionListener displayHelpFromSource;
    private static final boolean debug = false;
    static /* synthetic */ Class class$java$awt$Frame;

    static {
        HelpUtilities.installLookAndFeelDefaults();
    }

    public DefaultHelpBroker() {
    }

    public DefaultHelpBroker(HelpSet helpSet) {
        this.setHelpSet(helpSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private synchronized void createHelpFrame() {
        if (this.jhelp != null) {
            return;
        }
        String string = this.helpset.getTitle();
        this.frame = new JFrame(string);
        ((Component)this.frame).setSize(HELP_WIDTH, HELP_HEIGHT);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                ((Component)DefaultHelpBroker.this.frame).setVisible(false);
            }

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)DefaultHelpBroker.this.frame).setVisible(false);
            }
        };
        this.frame.addWindowListener(windowAdapter);
        this.jhelp = new JHelp(this.helpset);
        if (this.font != null) {
            this.jhelp.setFont(this.font);
        }
        this.frame.getContentPane().add(this.jhelp);
    }

    private static void debug(Object object) {
    }

    public void enableHelp(Component component, String string, HelpSet helpSet) {
        if (component == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
    }

    public void enableHelp(MenuItem menuItem, String string, HelpSet helpSet) {
        if (menuItem == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        CSH.setHelpIDString(menuItem, string);
        if (helpSet != null) {
            CSH.setHelpSet(menuItem, helpSet);
        }
    }

    public void enableHelpKey(Component component, String string, HelpSet helpSet) {
        if (component == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(156, 0), 2);
            jComponent.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(112, 0), 2);
        } else {
            component.addKeyListener(this);
        }
    }

    public void enableHelpOnButton(Component component, String string, HelpSet helpSet) throws IllegalArgumentException {
        if (!(component instanceof AbstractButton) && !(component instanceof Button)) {
            throw new IllegalArgumentException("Invalid Component");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.addActionListener(this.getDisplayHelpFromSource());
        } else if (component instanceof Button) {
            Button button = (Button)component;
            button.addActionListener(this.getDisplayHelpFromSource());
        }
    }

    public void enableHelpOnButton(MenuItem menuItem, String string, HelpSet helpSet) {
        if (menuItem == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        CSH.setHelpIDString(menuItem, string);
        if (helpSet != null) {
            CSH.setHelpSet(menuItem, helpSet);
        }
        menuItem.addActionListener(this.getDisplayHelpFromSource());
    }

    public Map.ID getCurrentID() {
        if (this.jhelp != null) {
            return this.jhelp.getModel().getCurrentID();
        }
        return null;
    }

    public URL getCurrentURL() {
        return this.jhelp.getModel().getCurrentURL();
    }

    public String getCurrentView() {
        this.initGUILock();
        this.createHelpFrame();
        this.initGUIUnlock();
        return this.jhelp.getCurrentNavigator().getNavigatorName();
    }

    protected ActionListener getDisplayHelpFromFocus() {
        if (this.displayHelpFromFocus == null) {
            this.displayHelpFromFocus = new CSH.DisplayHelpFromFocus(this);
        }
        return this.displayHelpFromFocus;
    }

    protected ActionListener getDisplayHelpFromSource() {
        if (this.displayHelpFromSource == null) {
            this.displayHelpFromSource = new CSH.DisplayHelpFromSource(this);
        }
        return this.displayHelpFromSource;
    }

    public Font getFont() {
        this.initGUILock();
        this.createHelpFrame();
        this.initGUIUnlock();
        if (this.font == null) {
            return this.jhelp.getFont();
        }
        return this.font;
    }

    public HelpSet getHelpSet() {
        return this.helpset;
    }

    public Locale getLocale() {
        Locale locale = this.locale;
        if (locale != null) {
            return Locale.getDefault();
        }
        return locale;
    }

    public Point getLocation() throws UnsupportedOperationException {
        if (this.jhelp == null) {
            return null;
        }
        return this.frame.getLocation();
    }

    private final synchronized void initGUILock() {
        try {
            while (this.currGUIInitThread != null) {
                if (this.currGUIInitThread == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private final synchronized void initGUIUnlock() {
        if (this.currGUIInitThread == Thread.currentThread()) {
            return;
        }
        this.notify();
    }

    public void initPresentation() {
        this.initGUILock();
        this.createHelpFrame();
        this.initGUIUnlock();
    }

    public boolean isDisplayed() {
        if (this.frame != null) {
            if (!this.frame.isVisible()) {
                return false;
            }
            try {
                Method method = (class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = DefaultHelpBroker.class$("java.awt.Frame"))).getMethod("getState", null);
                if (method != null) {
                    int n = (Integer)method.invoke((Object)this.frame, null);
                    return n == 0;
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            return true;
        }
        return false;
    }

    public boolean isViewDisplayed() {
        this.initGUILock();
        this.createHelpFrame();
        this.initGUIUnlock();
        return this.jhelp.isNavigatorDisplayed();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 112 || n == 156) {
            ActionListener actionListener = this.getDisplayHelpFromFocus();
            actionListener.actionPerformed(new ActionEvent(keyEvent.getComponent(), 1001, null));
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setCurrentID(String string) throws BadIDException {
        try {
            this.setCurrentID(Map.ID.create(string, this.helpset));
        }
        catch (InvalidHelpSetContextException invalidHelpSetContextException) {
            new Error("internal error?");
        }
    }

    public void setCurrentID(Map.ID iD) throws InvalidHelpSetContextException {
        DefaultHelpBroker.debug("setCurrentID");
        this.initGUILock();
        this.createHelpFrame();
        this.initGUIUnlock();
        this.jhelp.getModel().setCurrentID(iD);
        ((Component)this.frame).setVisible(true);
        this.frame.show();
    }

    public void setCurrentURL(URL uRL) {
        this.initGUILock();
        this.createHelpFrame();
        this.initGUIUnlock();
        this.jhelp.getModel().setCurrentURL(uRL);
        ((Component)this.frame).setVisible(true);
        this.frame.show();
    }

    public void setCurrentView(String string) {
        this.initGUILock();
        this.createHelpFrame();
        this.initGUIUnlock();
        JHelpNavigator jHelpNavigator = null;
        Enumeration enumeration = this.jhelp.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
            if (jHelpNavigator.getNavigatorName().equals(string)) break;
            jHelpNavigator = null;
        }
        if (jHelpNavigator == null) {
            throw new IllegalArgumentException("Invalid view name");
        }
        this.jhelp.setCurrentNavigator(jHelpNavigator);
    }

    public void setDisplayed(boolean bl) {
        this.initGUILock();
        this.createHelpFrame();
        this.initGUIUnlock();
        ((Component)this.frame).setVisible(bl);
        try {
            Class[] classArray = new Class[]{Integer.TYPE};
            Method method = (class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = DefaultHelpBroker.class$("java.awt.Frame"))).getMethod("setState", classArray);
            if (method != null) {
                Object[] objectArray = new Object[]{new Integer(0)};
                method.invoke((Object)this.frame, objectArray);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.jhelp != null) {
            this.jhelp.setFont(this.font);
        }
    }

    public void setHelpSet(HelpSet helpSet) {
        if (helpSet != null && this.helpset != helpSet) {
            if (this.jhelp != null) {
                DefaultHelpModel defaultHelpModel = new DefaultHelpModel(helpSet);
                this.jhelp.setModel(defaultHelpModel);
            }
            this.helpset = helpSet;
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocation(Point point) throws UnsupportedOperationException {
        this.initGUILock();
        this.createHelpFrame();
        this.initGUIUnlock();
        ((Component)this.frame).setLocation(point);
    }

    public void setViewDisplayed(boolean bl) {
        this.initGUILock();
        this.createHelpFrame();
        this.initGUIUnlock();
        this.jhelp.setNavigatorDisplayed(bl);
    }
}

